/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata.filter.gateway;

import com.tencent.cloud.common.constant.MetadataConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MetadataFirstScgFilter
implements GlobalFilter,
Ordered {
    public static final int METADATA_FIRST_FILTER_ORDER = 10001;

    public int getOrder() {
        return 10001;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        MetadataContext metadataContext = (MetadataContext)exchange.getAttribute("SCT-METADATA-CONTEXT");
        if (metadataContext == null) {
            metadataContext = MetadataContextHolder.get();
        }
        metadataContext.putSystemMetadata(MetadataConstant.SystemMetadataKey.PEER_NAMESPACE, MetadataContext.LOCAL_NAMESPACE);
        if (route != null) {
            metadataContext.putSystemMetadata(MetadataConstant.SystemMetadataKey.PEER_SERVICE, route.getUri().getAuthority());
        } else {
            metadataContext.putSystemMetadata(MetadataConstant.SystemMetadataKey.PEER_SERVICE, exchange.getRequest().getURI().getAuthority());
        }
        metadataContext.putSystemMetadata(MetadataConstant.SystemMetadataKey.PEER_PATH, exchange.getRequest().getURI().getPath());
        exchange.getAttributes().put("SCT-METADATA-CONTEXT", metadataContext);
        return chain.filter(exchange);
    }
}

