/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.pojo;

import com.netflix.loadbalancer.Server;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class PolarisServer
extends Server {
    private final ServiceInstances serviceInstances;
    private final Instance instance;
    private final Server.MetaInfo metaInfo;

    public PolarisServer(ServiceInstances serviceInstances, final Instance instance) {
        super(instance.getHost(), instance.getPort());
        if (StringUtils.equalsIgnoreCase((String)instance.getProtocol(), (String)"https")) {
            this.setSchemea("https");
        } else {
            this.setSchemea("http");
        }
        this.serviceInstances = serviceInstances;
        this.instance = instance;
        this.metaInfo = new Server.MetaInfo(){

            public String getAppName() {
                return instance.getService();
            }

            public String getServerGroup() {
                return null;
            }

            public String getServiceIdForDiscovery() {
                return instance.getService();
            }

            public String getInstanceId() {
                return instance.getId();
            }
        };
    }

    public Instance getInstance() {
        return this.instance;
    }

    public Server.MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public Map<String, String> getMetadata() {
        return this.instance.getMetadata();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolarisServer that = (PolarisServer)((Object)o);
        return Objects.equals(this.instance, that.instance);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.instance);
    }

    public ServiceInstances getServiceInstances() {
        return this.serviceInstances;
    }
}

