/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.common.metadata.config.MetadataLocalProperties;
import com.tencent.cloud.common.util.ApplicationContextAwareUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public final class MetadataContextHolder {
    private static final ThreadLocal<MetadataContext> METADATA_CONTEXT = new InheritableThreadLocal<MetadataContext>();
    private static MetadataLocalProperties metadataLocalProperties;
    private static StaticMetadataManager staticMetadataManager;

    private MetadataContextHolder() {
    }

    public static MetadataContext get() {
        if (METADATA_CONTEXT.get() != null) {
            return METADATA_CONTEXT.get();
        }
        if (metadataLocalProperties == null) {
            metadataLocalProperties = (MetadataLocalProperties)ApplicationContextAwareUtils.getApplicationContext().getBean("metadataLocalProperties");
        }
        if (staticMetadataManager == null) {
            staticMetadataManager = (StaticMetadataManager)ApplicationContextAwareUtils.getApplicationContext().getBean("metadataManager");
        }
        MetadataContext metadataContext = new MetadataContext();
        metadataContext.putFragmentContext("transitive", staticMetadataManager.getMergedStaticTransitiveMetadata());
        METADATA_CONTEXT.set(metadataContext);
        return METADATA_CONTEXT.get();
    }

    public static void set(MetadataContext metadataContext) {
        METADATA_CONTEXT.set(metadataContext);
    }

    public static void init(Map<String, String> dynamicTransitiveMetadata) {
        MetadataContextHolder.remove();
        MetadataContext metadataContext = MetadataContextHolder.get();
        if (!CollectionUtils.isEmpty(dynamicTransitiveMetadata)) {
            Map<String, String> staticTransitiveMetadata = metadataContext.getFragmentContext("transitive");
            HashMap<String, String> mergedTransitiveMetadata = new HashMap<String, String>();
            mergedTransitiveMetadata.putAll(staticTransitiveMetadata);
            mergedTransitiveMetadata.putAll(dynamicTransitiveMetadata);
            metadataContext.putFragmentContext("transitive", Collections.unmodifiableMap(mergedTransitiveMetadata));
        }
        MetadataContextHolder.set(metadataContext);
    }

    public static void remove() {
        METADATA_CONTEXT.remove();
    }
}

