/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata;

import com.tencent.cloud.common.metadata.config.MetadataLocalProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticMetadataManager.class);
    private static final String ENV_METADATA_PREFIX = "SCT_METADATA_CONTENT_";
    private static final int ENV_METADATA_PREFIX_LENGTH = "SCT_METADATA_CONTENT_".length();
    private static final String ENV_METADATA_CONTENT_TRANSITIVE = "SCT_METADATA_CONTENT_TRANSITIVE";
    private static final String ENV_METADATA_ZONE = "SCT_METADATA_ZONE";
    private static final String ENV_METADATA_REGION = "SCT_METADATA_REGION";
    private static final String ENV_METADATA_CAMPUS = "SCT_METADATA_CAMPUS";
    private static final String LOCATION_KEY_REGION = "region";
    private static final String LOCATION_KEY_ZONE = "zone";
    private static final String LOCATION_KEY_CAMPUS = "campus";
    private Map<String, String> envMetadata;
    private Map<String, String> envTransitiveMetadata;
    private Map<String, String> configMetadata;
    private Map<String, String> configTransitiveMetadata;
    private Map<String, String> mergedStaticMetadata;
    private Map<String, String> mergedStaticTransitiveMetadata;
    private String zone;
    private String region;
    private String campus;

    public StaticMetadataManager(MetadataLocalProperties metadataLocalProperties) {
        this.parseConfigMetadata(metadataLocalProperties);
        this.parseEnvMetadata();
        this.merge();
        this.parseLocationMetadata();
        LOGGER.info("[SCT] Loaded static metadata info. {}", (Object)this);
    }

    private void parseEnvMetadata() {
        String[] keyArr;
        Map<String, String> allEnvs = System.getenv();
        this.envMetadata = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : allEnvs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((String)key) || !key.startsWith(ENV_METADATA_PREFIX) || key.equals(ENV_METADATA_CONTENT_TRANSITIVE)) continue;
            String sourceKey = StringUtils.substring((String)key, (int)ENV_METADATA_PREFIX_LENGTH);
            this.envMetadata.put(sourceKey, value);
            LOGGER.info("[SCT] resolve metadata from env. key = {}, value = {}", (Object)sourceKey, (Object)value);
        }
        this.envMetadata = Collections.unmodifiableMap(this.envMetadata);
        this.envTransitiveMetadata = new HashMap<String, String>();
        String transitiveKeys = allEnvs.get(ENV_METADATA_CONTENT_TRANSITIVE);
        if (StringUtils.isNotBlank((String)transitiveKeys) && (keyArr = StringUtils.split((String)transitiveKeys, (String)",")) != null && keyArr.length > 0) {
            for (String key : keyArr) {
                String value = this.envMetadata.get(key);
                if (!StringUtils.isNotBlank((String)value)) continue;
                this.envTransitiveMetadata.put(key, value);
            }
        }
        this.envTransitiveMetadata = Collections.unmodifiableMap(this.envTransitiveMetadata);
    }

    private void parseConfigMetadata(MetadataLocalProperties metadataLocalProperties) {
        Map<String, String> allMetadata = metadataLocalProperties.getContent();
        List<String> transitiveKeys = metadataLocalProperties.getTransitive();
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : transitiveKeys) {
            if (!allMetadata.containsKey(key)) continue;
            result.put(key, allMetadata.get(key));
        }
        this.configTransitiveMetadata = Collections.unmodifiableMap(result);
        this.configMetadata = Collections.unmodifiableMap(allMetadata);
    }

    private void merge() {
        HashMap<String, String> mergedMetadataResult = new HashMap<String, String>();
        mergedMetadataResult.putAll(this.configMetadata);
        mergedMetadataResult.putAll(this.envMetadata);
        this.mergedStaticMetadata = Collections.unmodifiableMap(mergedMetadataResult);
        HashMap<String, String> mergedTransitiveMetadataResult = new HashMap<String, String>();
        mergedTransitiveMetadataResult.putAll(this.configTransitiveMetadata);
        mergedTransitiveMetadataResult.putAll(this.envTransitiveMetadata);
        this.mergedStaticTransitiveMetadata = Collections.unmodifiableMap(mergedTransitiveMetadataResult);
    }

    private void parseLocationMetadata() {
        this.zone = System.getenv(ENV_METADATA_ZONE);
        this.region = System.getenv(ENV_METADATA_REGION);
        this.campus = System.getenv(ENV_METADATA_CAMPUS);
    }

    public Map<String, String> getAllEnvMetadata() {
        return this.envMetadata;
    }

    public Map<String, String> getEnvTransitiveMetadata() {
        return this.envTransitiveMetadata;
    }

    public Map<String, String> getAllConfigMetadata() {
        return this.configMetadata;
    }

    public Map<String, String> getConfigTransitiveMetadata() {
        return this.configTransitiveMetadata;
    }

    public Map<String, String> getMergedStaticMetadata() {
        return this.mergedStaticMetadata;
    }

    public Map<String, String> getMergedStaticTransitiveMetadata() {
        return this.mergedStaticTransitiveMetadata;
    }

    public String getZone() {
        return this.zone;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCampus() {
        return this.campus;
    }

    public Map<String, String> getLocationMetadata() {
        HashMap<String, String> locationMetadata = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.region)) {
            locationMetadata.put(LOCATION_KEY_REGION, this.region);
        }
        if (StringUtils.isNotBlank((String)this.zone)) {
            locationMetadata.put(LOCATION_KEY_ZONE, this.zone);
        }
        if (StringUtils.isNotBlank((String)this.campus)) {
            locationMetadata.put(LOCATION_KEY_CAMPUS, this.campus);
        }
        return locationMetadata;
    }

    public String toString() {
        return "StaticMetadataManager{envMetadata=" + this.envMetadata + ", envTransitiveMetadata=" + this.envTransitiveMetadata + ", configMetadata=" + this.configMetadata + ", configTransitiveMetadata=" + this.configTransitiveMetadata + ", mergedStaticMetadata=" + this.mergedStaticMetadata + ", mergedStaticTransitiveMetadata=" + this.mergedStaticTransitiveMetadata + ", zone='" + this.zone + '\'' + ", region='" + this.region + '\'' + ", campus='" + this.campus + '\'' + '}';
    }
}

