/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class BeanFactoryUtils {
    public static <T> List<T> getBeans(BeanFactory beanFactory, Class<T> requiredType) {
        if (!(beanFactory instanceof DefaultListableBeanFactory)) {
            throw new RuntimeException("bean factory not support get list bean. factory type = " + beanFactory.getClass().getName());
        }
        String[] beanNames = ((DefaultListableBeanFactory)beanFactory).getBeanNamesForType(requiredType);
        if (beanNames.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(beanNames).map(beanName -> beanFactory.getBean(beanName, requiredType)).collect(Collectors.toList());
    }
}

