/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class ExpressionLabelUtils {
    public static final String LABEL_HEADER_PREFIX = "${http.header.";
    public static final int LABEL_HEADER_PREFIX_LEN = "${http.header.".length();
    public static final String LABEL_QUERY_PREFIX = "${http.query.";
    public static final int LABEL_QUERY_PREFIX_LEN = "${http.query.".length();
    public static final String LABEL_COOKIE_PREFIX = "${http.cookie.";
    public static final int LABEL_COOKIE_PREFIX_LEN = "${http.cookie.".length();
    public static final String LABEL_METHOD = "${http.method}";
    public static final String LABEL_URI = "${http.uri}";
    public static final String LABEL_PREFIX = "${";
    public static final String LABEL_SUFFIX = "}";
    public static final String LABEL_ESCAPE_PREFIX = "##@$@##";

    public static boolean isExpressionLabel(String labelKey) {
        if (StringUtils.isEmpty((String)labelKey)) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((String)LABEL_METHOD, (String)labelKey) || StringUtils.startsWithIgnoreCase((String)LABEL_URI, (String)labelKey)) {
            return true;
        }
        return (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_HEADER_PREFIX) || StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_QUERY_PREFIX) || StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_COOKIE_PREFIX)) && StringUtils.endsWith((String)labelKey, (String)LABEL_SUFFIX);
    }

    public static String escape(String str) {
        return StringUtils.replace((String)str, (String)LABEL_PREFIX, (String)LABEL_ESCAPE_PREFIX);
    }

    public static String unescape(String str) {
        return StringUtils.replace((String)str, (String)LABEL_ESCAPE_PREFIX, (String)LABEL_PREFIX);
    }

    public static Map<String, String> resolve(HttpServletRequest request, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isExpressionLabel(labelKey)) continue;
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_HEADER_PREFIX)) {
                String headerKey = ExpressionLabelUtils.parseHeaderKey(labelKey);
                if (StringUtils.isBlank((String)headerKey)) continue;
                labels.put(labelKey, request.getHeader(headerKey));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_QUERY_PREFIX)) {
                String queryKey = ExpressionLabelUtils.parseQueryKey(labelKey);
                if (StringUtils.isBlank((String)queryKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getQueryValue(request.getQueryString(), queryKey));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_COOKIE_PREFIX)) {
                String cookieKey = ExpressionLabelUtils.parseCookieKey(labelKey);
                if (StringUtils.isBlank((String)cookieKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getCookieValue(request.getCookies(), cookieKey));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)LABEL_METHOD, (String)labelKey)) {
                labels.put(labelKey, request.getMethod());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)LABEL_URI, (String)labelKey)) continue;
            labels.put(labelKey, request.getRequestURI());
        }
        return labels;
    }

    public static Map<String, String> resolve(ServerWebExchange exchange, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isExpressionLabel(labelKey)) continue;
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_HEADER_PREFIX)) {
                String headerKey = ExpressionLabelUtils.parseHeaderKey(labelKey);
                if (StringUtils.isBlank((String)headerKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getHeaderValue(exchange.getRequest(), headerKey));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_QUERY_PREFIX)) {
                String queryKey = ExpressionLabelUtils.parseQueryKey(labelKey);
                if (StringUtils.isBlank((String)queryKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getQueryValue(exchange.getRequest(), queryKey));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_COOKIE_PREFIX)) {
                String cookieKey = ExpressionLabelUtils.parseCookieKey(labelKey);
                if (StringUtils.isBlank((String)cookieKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getCookieValue(exchange.getRequest(), cookieKey));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)LABEL_METHOD, (String)labelKey)) {
                labels.put(labelKey, exchange.getRequest().getMethodValue());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)LABEL_URI, (String)labelKey)) continue;
            labels.put(labelKey, exchange.getRequest().getURI().getPath());
        }
        return labels;
    }

    public static Map<String, String> resolve(HttpRequest request, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isExpressionLabel(labelKey)) continue;
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_HEADER_PREFIX)) {
                String headerKey = ExpressionLabelUtils.parseHeaderKey(labelKey);
                if (StringUtils.isBlank((String)headerKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getHeaderValue(request, headerKey));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)labelKey, (String)LABEL_QUERY_PREFIX)) {
                String queryKey = ExpressionLabelUtils.parseQueryKey(labelKey);
                if (StringUtils.isBlank((String)queryKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getQueryValue(request, queryKey));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)LABEL_METHOD, (String)labelKey)) {
                labels.put(labelKey, request.getMethodValue());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)LABEL_URI, (String)labelKey)) continue;
            labels.put(labelKey, request.getURI().getPath());
        }
        return labels;
    }

    public static String parseHeaderKey(String expression) {
        return expression.substring(LABEL_HEADER_PREFIX_LEN, expression.length() - 1);
    }

    public static String parseQueryKey(String expression) {
        return expression.substring(LABEL_QUERY_PREFIX_LEN, expression.length() - 1);
    }

    public static String parseCookieKey(String expression) {
        return expression.substring(LABEL_COOKIE_PREFIX_LEN, expression.length() - 1);
    }

    public static String getQueryValue(String queryString, String queryKey) {
        if (StringUtils.isBlank((String)queryString)) {
            return "";
        }
        String[] queries = StringUtils.split((String)queryString, (String)"&");
        if (queries == null || queries.length == 0) {
            return "";
        }
        for (String query : queries) {
            String[] queryKV = StringUtils.split((String)query, (String)"=");
            if (queryKV == null || queryKV.length != 2 || !StringUtils.equals((String)queryKV[0], (String)queryKey)) continue;
            return queryKV[1];
        }
        return "";
    }

    public static String getCookieValue(Cookie[] cookies, String key) {
        if (cookies == null || cookies.length == 0) {
            return "";
        }
        for (Cookie cookie : cookies) {
            if (!StringUtils.equals((String)cookie.getName(), (String)key)) continue;
            return cookie.getValue();
        }
        return "";
    }

    public static String getHeaderValue(ServerHttpRequest request, String key) {
        String value = request.getHeaders().getFirst(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getQueryValue(ServerHttpRequest request, String key) {
        MultiValueMap queries = request.getQueryParams();
        if (CollectionUtils.isEmpty((Map)queries)) {
            return "";
        }
        String value = (String)queries.getFirst((Object)key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getCookieValue(ServerHttpRequest request, String key) {
        HttpCookie cookie = (HttpCookie)request.getCookies().getFirst((Object)key);
        if (cookie == null) {
            return "";
        }
        return cookie.getValue();
    }

    public static String getHeaderValue(HttpRequest request, String key) {
        HttpHeaders headers = request.getHeaders();
        return headers.getFirst(key);
    }

    public static String getQueryValue(HttpRequest request, String key) {
        String query = request.getURI().getQuery();
        return ExpressionLabelUtils.getQueryValue(query, key);
    }

    public static String getFirstValue(Map<String, Collection<String>> valueMaps, String key) {
        if (CollectionUtils.isEmpty(valueMaps)) {
            return "";
        }
        Collection<String> values = valueMaps.get(key);
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        Iterator<String> iterator = values.iterator();
        if (iterator.hasNext()) {
            String value = iterator.next();
            return value;
        }
        return "";
    }
}

