/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class JacksonUtils {
    public static final ObjectMapper OM = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(JacksonUtils.class);

    private JacksonUtils() {
    }

    public static <T> String serialize2Json(T object) {
        try {
            return OM.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOG.error("Object to Json failed. {}", object, (Object)e);
            throw new RuntimeException("Object to Json failed.", e);
        }
    }

    public static Map<String, String> deserialize2Map(String jsonStr) {
        try {
            if (StringUtils.hasText((String)jsonStr)) {
                Map temp = (Map)OM.readValue(jsonStr, Map.class);
                HashMap<String, String> result = new HashMap<String, String>();
                temp.forEach((key, value) -> result.put(String.valueOf(key), String.valueOf(value)));
                return result;
            }
            return new HashMap<String, String>();
        }
        catch (JsonProcessingException e) {
            LOG.error("Json to map failed. check if the format of the json string[{}] is correct.", (Object)jsonStr, (Object)e);
            throw new RuntimeException("Json to map failed.", e);
        }
    }
}

