/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.plugin.featureenv;

import com.tencent.cloud.polaris.router.PolarisRouterContext;
import com.tencent.cloud.polaris.router.spi.RouterRequestInterceptor;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.router.api.rpc.ProcessRoutersRequest;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class FeatureEnvRouterRequestInterceptor
implements RouterRequestInterceptor {
    private static final String LABEL_KEY_FEATURE_ENV_ROUTER_KEY = "system-feature-env-router-label";
    private static final String DEFAULT_FEATURE_ENV_ROUTER_LABEL = "featureenv";
    private static final String NOT_EXISTED_ENV = "NOT_EXISTED_ENV";

    public void apply(ProcessRoutersRequest request, PolarisRouterContext routerContext) {
        String envLabelValue;
        String envLabelKey = routerContext.getLabel(LABEL_KEY_FEATURE_ENV_ROUTER_KEY);
        if (StringUtils.isBlank((String)envLabelKey)) {
            envLabelKey = DEFAULT_FEATURE_ENV_ROUTER_LABEL;
        }
        if ((envLabelValue = routerContext.getLabel(envLabelKey)) == null) {
            envLabelValue = NOT_EXISTED_ENV;
        }
        HashMap<String, String> envMetadata = new HashMap<String, String>();
        envMetadata.put(envLabelKey, envLabelValue);
        request.addRouterMetadata("metadataRoute", envMetadata);
        request.setMetadataFailoverType(MetadataFailoverType.METADATAFAILOVERNOTKEY);
    }
}

