/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.feign;

import com.tencent.cloud.common.util.ReflectionUtils;
import com.tencent.cloud.feign.PluggableFeignContractHolder;
import com.tencent.cloud.feign.PluggableFeignInvocationHandler;
import com.tencent.cloud.feign.PluggableFeignPlugin;
import feign.Contract;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.hystrix.FallbackFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class PluggableFeign {
    private static final Logger LOG = LoggerFactory.getLogger(PluggableFeign.class);

    private PluggableFeign() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Feign.Builder
    implements ApplicationContextAware {
        private Contract contract = new Contract.Default();
        private ApplicationContext applicationContext;
        private FeignContext feignContext;

        public Feign.Builder invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            throw new UnsupportedOperationException();
        }

        public Builder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
            this.feignContext = (FeignContext)applicationContext.getBean(FeignContext.class);
        }

        public Feign build() {
            super.invocationHandlerFactory(new InvocationHandlerFactory(){

                public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
                    Object feignClientFactoryBean = applicationContext.getBean("&" + target.type().getName());
                    Class fallback = (Class)ReflectionUtils.getFieldValue((Object)feignClientFactoryBean, (String)"fallback");
                    Class fallbackFactory = (Class)ReflectionUtils.getFieldValue((Object)feignClientFactoryBean, (String)"fallbackFactory");
                    String beanName = (String)ReflectionUtils.getFieldValue((Object)feignClientFactoryBean, (String)"contextId");
                    if (!StringUtils.hasText((String)beanName)) {
                        beanName = (String)ReflectionUtils.getFieldValue((Object)feignClientFactoryBean, (String)"name");
                    }
                    List<PluggableFeignPlugin> pluggableFeignPlugins = this.getSortedFeignPrePlugins();
                    if (Void.TYPE != fallback) {
                        Object fallbackInstance = this.getFallbackInstanceFromContext(beanName, "fallback", fallback, target.type());
                        return new PluggableFeignInvocationHandler(target, dispatch, (FallbackFactory)new FallbackFactory.Default(fallbackInstance), pluggableFeignPlugins);
                    }
                    if (Void.TYPE != fallbackFactory) {
                        FallbackFactory fallbackFactoryInstance = (FallbackFactory)this.getFallbackInstanceFromContext(beanName, "fallbackFactory", fallbackFactory, FallbackFactory.class);
                        return new PluggableFeignInvocationHandler(target, dispatch, fallbackFactoryInstance, pluggableFeignPlugins);
                    }
                    return new PluggableFeignInvocationHandler(target, dispatch, null, pluggableFeignPlugins);
                }

                private Object getFallbackInstanceFromContext(String name, String type, Class fallbackType, Class targetType) {
                    Object fallbackInstance;
                    if (feignContext == null) {
                        feignContext = (FeignContext)applicationContext.getBean(FeignContext.class);
                    }
                    if ((fallbackInstance = feignContext.getInstance(name, fallbackType)) == null) {
                        throw new IllegalStateException(String.format("No %s instance of type %s found for feign client %s", type, fallbackType, name));
                    }
                    if (!targetType.isAssignableFrom(fallbackType)) {
                        throw new IllegalStateException(String.format("Incompatible %s instance. Fallback/fallbackFactory of type %s is not assignable to %s for feign client %s", type, fallbackType, targetType, name));
                    }
                    return fallbackInstance;
                }

                private List<PluggableFeignPlugin> getSortedFeignPrePlugins() {
                    Map feignPrePluginMap = applicationContext.getBeansOfType(PluggableFeignPlugin.class);
                    return new ArrayList(feignPrePluginMap.values()).stream().sorted(Comparator.comparing(Ordered::getOrder)).collect(Collectors.toList());
                }
            });
            super.contract((Contract)new PluggableFeignContractHolder(this.contract));
            return super.build();
        }
    }
}

