/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.feign;

import com.tencent.cloud.feign.PluggableFeignContext;
import com.tencent.cloud.feign.PluggableFeignPlugin;
import com.tencent.cloud.feign.PluggableFeignPluginType;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import feign.hystrix.FallbackFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PluggableFeignInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PluggableFeignInvocationHandler.class);
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;
    private FallbackFactory fallbackFactory;
    private Map<Method, Method> fallbackMethodMap;
    private List<PluggableFeignPlugin> prePluggableFeignPlugins;
    private List<PluggableFeignPlugin> postPluggableFeignPlugins;
    private List<PluggableFeignPlugin> exceptionPluggableFeignPlugins;

    PluggableFeignInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, FallbackFactory fallbackFactory, List<PluggableFeignPlugin> pluggableFeignPlugins) {
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
        this.fallbackFactory = fallbackFactory;
        this.fallbackMethodMap = PluggableFeignInvocationHandler.toFallbackMethod(dispatch);
        this.prePluggableFeignPlugins = new ArrayList<PluggableFeignPlugin>();
        this.postPluggableFeignPlugins = new ArrayList<PluggableFeignPlugin>();
        this.exceptionPluggableFeignPlugins = new ArrayList<PluggableFeignPlugin>();
        for (PluggableFeignPlugin feignPlugin : pluggableFeignPlugins) {
            if (feignPlugin.getType().equals((Object)PluggableFeignPluginType.PRE)) {
                this.prePluggableFeignPlugins.add(feignPlugin);
                continue;
            }
            if (feignPlugin.getType().equals((Object)PluggableFeignPluginType.POST)) {
                this.postPluggableFeignPlugins.add(feignPlugin);
                continue;
            }
            if (!feignPlugin.getType().equals((Object)PluggableFeignPluginType.EXCEPTION)) continue;
            this.exceptionPluggableFeignPlugins.add(feignPlugin);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName())) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        Object result = null;
        PluggableFeignContext context = new PluggableFeignContext();
        try {
            context.setTarget(this.target);
            context.setDispatch(this.dispatch);
            context.setFallbackFactory(this.fallbackFactory);
            context.setFallbackMethodMap(this.fallbackMethodMap);
            context.setProxy(proxy);
            context.setMethod(method);
            context.setArgs(args);
            for (PluggableFeignPlugin prePlugin : this.prePluggableFeignPlugins) {
                prePlugin.run(context);
            }
            result = this.dispatch.get(method).invoke(args);
            context.setResult(result);
            for (PluggableFeignPlugin postPlugin : this.postPluggableFeignPlugins) {
                postPlugin.run(context);
            }
        }
        catch (Throwable throwable) {
            if (throwable.getCause() instanceof FeignException) {
                context.setFeignException((FeignException)throwable.getCause());
            }
            for (PluggableFeignPlugin exceptionPlugin : this.exceptionPluggableFeignPlugins) {
                exceptionPlugin.run(context);
            }
            if (this.fallbackFactory != null) {
                return this.fallbackMethodMap.get(method).invoke(this.fallbackFactory.create(throwable), args);
            }
            LOG.error("FallbackFactory is null!");
            throw throwable;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PluggableFeignInvocationHandler) {
            PluggableFeignInvocationHandler other = (PluggableFeignInvocationHandler)obj;
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    static Map<Method, Method> toFallbackMethod(Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        LinkedHashMap<Method, Method> result = new LinkedHashMap<Method, Method>();
        if (!CollectionUtils.isEmpty(dispatch)) {
            for (Method method : dispatch.keySet()) {
                method.setAccessible(true);
                result.put(method, method);
            }
        }
        return result;
    }
}

