/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.config;

import com.tencent.cloud.feign.PluggableFeign;
import com.tencent.cloud.metadata.config.MetadataLocalProperties;
import com.tencent.cloud.metadata.core.filter.MetadataReactiveFilter;
import com.tencent.cloud.metadata.core.filter.MetadataServletFilter;
import com.tencent.cloud.metadata.core.interceptor.feign.Metadata2HeaderFeignInterceptor;
import com.tencent.cloud.metadata.core.interceptor.resttemplate.MetadataRestTemplateInterceptor;
import com.tencent.cloud.metadata.core.plugin.feign.MetadataFirstFeignPlugin;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
public class MetadataConfiguration {
    @Bean
    public MetadataLocalProperties metadataLocalProperties() {
        return new MetadataLocalProperties();
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class})
    static class MetadataRestTemplateConfig
    implements ApplicationContextAware {
        private ApplicationContext context;

        MetadataRestTemplateConfig() {
        }

        @Bean
        public MetadataRestTemplateInterceptor metadataRestTemplateInterceptor() {
            return new MetadataRestTemplateInterceptor();
        }

        @Bean
        BeanPostProcessor metadataRestTemplatePostProcessor(MetadataRestTemplateInterceptor metadataRestTemplateInterceptor) {
            Map beans = this.context.getBeansOfType(RestTemplate.class);
            if (!CollectionUtils.isEmpty((Map)beans)) {
                for (RestTemplate restTemplate : beans.values()) {
                    List interceptors = restTemplate.getInterceptors();
                    if (null == interceptors || interceptors.contains(metadataRestTemplateInterceptor)) continue;
                    interceptors.add(metadataRestTemplateInterceptor);
                    restTemplate.setInterceptors(interceptors);
                }
            }
            return new MetadataRestTemplatePostProcessor(metadataRestTemplateInterceptor);
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.context = applicationContext;
        }

        public static class MetadataRestTemplatePostProcessor
        implements BeanPostProcessor {
            private MetadataRestTemplateInterceptor metadataRestTemplateInterceptor;

            MetadataRestTemplatePostProcessor(MetadataRestTemplateInterceptor metadataRestTemplateInterceptor) {
                this.metadataRestTemplateInterceptor = metadataRestTemplateInterceptor;
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) {
                RestTemplate restTemplate;
                List interceptors;
                if (bean instanceof RestTemplate && null != (interceptors = (restTemplate = (RestTemplate)bean).getInterceptors()) && !interceptors.contains(this.metadataRestTemplateInterceptor)) {
                    interceptors.add(this.metadataRestTemplateInterceptor);
                    restTemplate.setInterceptors(interceptors);
                }
                return bean;
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={PluggableFeign.Builder.class})
    static class MetadataFeignPluginConfig {
        MetadataFeignPluginConfig() {
        }

        @Bean
        public MetadataFirstFeignPlugin metadataFirstFeignPlugin() {
            return new MetadataFirstFeignPlugin();
        }

        @Bean
        public Metadata2HeaderFeignInterceptor metadataFeignInterceptor() {
            return new Metadata2HeaderFeignInterceptor();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class MetadataReactiveFilterConfig {
        MetadataReactiveFilterConfig() {
        }

        @Bean
        public MetadataReactiveFilter metadataReactiveFilter(MetadataLocalProperties metadataLocalProperties) {
            return new MetadataReactiveFilter();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class MetadataServletFilterConfig {
        MetadataServletFilterConfig() {
        }

        @Bean
        public FilterRegistrationBean<MetadataServletFilter> metadataServletFilterRegistrationBean(MetadataServletFilter metadataServletFilter) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)metadataServletFilter, new ServletRegistrationBean[0]);
            filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
            filterRegistrationBean.setOrder(-2147483645);
            return filterRegistrationBean;
        }

        @Bean
        public MetadataServletFilter metadataServletFilter(MetadataLocalProperties metadataLocalProperties) {
            return new MetadataServletFilter();
        }
    }
}

