/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.context;

import com.tencent.cloud.common.util.ApplicationContextAwareUtils;
import com.tencent.cloud.metadata.config.MetadataLocalProperties;
import com.tencent.cloud.metadata.context.MetadataContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class MetadataContextHolder {
    private static final ThreadLocal<MetadataContext> METADATA_CONTEXT = new InheritableThreadLocal<MetadataContext>();
    private static MetadataLocalProperties metadataLocalProperties;
    public static final String LOCAL_NAMESPACE;
    private static final String LOCAL_SPRING_APPLICATION_NAME;
    public static final String LOCAL_SERVICE;

    public static MetadataContext get() {
        if (null == METADATA_CONTEXT.get()) {
            MetadataContext metadataContext = new MetadataContext();
            if (metadataLocalProperties == null) {
                metadataLocalProperties = (MetadataLocalProperties)ApplicationContextAwareUtils.getApplicationContext().getBean("metadataLocalProperties");
            }
            Map<String, String> transitiveMetadataMap = MetadataContextHolder.getTransitiveMetadataMap(metadataLocalProperties.getContent(), metadataLocalProperties.getTransitive());
            metadataContext.putAllTransitiveCustomMetadata(transitiveMetadataMap);
            metadataContext.putSystemMetadata("LOCAL_NAMESPACE", LOCAL_NAMESPACE);
            metadataContext.putSystemMetadata("LOCAL_SERVICE", LOCAL_SERVICE);
            METADATA_CONTEXT.set(metadataContext);
        }
        return METADATA_CONTEXT.get();
    }

    private static Map<String, String> getTransitiveMetadataMap(Map<String, String> source, List<String> transitiveMetadataKeyList) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : transitiveMetadataKeyList) {
            if (!source.containsKey(key)) continue;
            result.put(key, source.get(key));
        }
        return result;
    }

    public static void set(MetadataContext metadataContext) {
        METADATA_CONTEXT.set(metadataContext);
    }

    public static void init(Map<String, String> customMetadataMap, Map<String, String> systemMetadataMap) {
        MetadataContextHolder.remove();
        MetadataContext metadataContext = MetadataContextHolder.get();
        if (!CollectionUtils.isEmpty(customMetadataMap)) {
            metadataContext.putAllTransitiveCustomMetadata(customMetadataMap);
        }
        if (!CollectionUtils.isEmpty(systemMetadataMap)) {
            metadataContext.putAllSystemMetadata(systemMetadataMap);
        }
        MetadataContextHolder.set(metadataContext);
    }

    public static void remove() {
        METADATA_CONTEXT.remove();
    }

    static {
        LOCAL_NAMESPACE = ApplicationContextAwareUtils.getProperties((String)"spring.cloud.polaris.discovery.namespace", (String)"default");
        LOCAL_SPRING_APPLICATION_NAME = ApplicationContextAwareUtils.getProperties((String)"spring.application.name", null);
        LOCAL_SERVICE = ApplicationContextAwareUtils.getProperties((String)"spring.cloud.polaris.discovery.service", (String)LOCAL_SPRING_APPLICATION_NAME);
    }
}

