/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core.filter;

import com.tencent.cloud.metadata.context.MetadataContextHolder;
import com.tencent.cloud.metadata.util.JacksonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class MetadataReactiveFilter
implements WebFilter,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataReactiveFilter.class);

    public int getOrder() {
        return -2147483645;
    }

    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest();
        HttpHeaders httpHeaders = serverHttpRequest.getHeaders();
        String customMetadataStr = httpHeaders.getFirst("SCT-CUSTOM-METADATA");
        try {
            if (StringUtils.hasText((String)customMetadataStr)) {
                customMetadataStr = URLDecoder.decode(customMetadataStr, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Runtime system does not support utf-8 coding.", (Throwable)e);
        }
        LOG.debug("Get upstream metadata string: {}", (Object)customMetadataStr);
        Map<String, String> upstreamCustomMetadataMap = JacksonUtils.deserialize2Map(customMetadataStr);
        HashMap<String, String> systemMetadataMap = new HashMap<String, String>();
        systemMetadataMap.put("LOCAL_NAMESPACE", MetadataContextHolder.LOCAL_NAMESPACE);
        systemMetadataMap.put("LOCAL_SERVICE", MetadataContextHolder.LOCAL_SERVICE);
        systemMetadataMap.put("LOCAL_PATH", serverHttpRequest.getURI().getPath());
        MetadataContextHolder.init(upstreamCustomMetadataMap, systemMetadataMap);
        serverWebExchange.getAttributes().put("SCT-METADATA-CONTEXT", MetadataContextHolder.get());
        return webFilterChain.filter(serverWebExchange).doOnError(throwable -> LOG.error("handle metadata[{}] error.", (Object)MetadataContextHolder.get(), throwable)).doFinally(type -> MetadataContextHolder.remove());
    }
}

