/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core.filter;

import com.tencent.cloud.metadata.context.MetadataContextHolder;
import com.tencent.cloud.metadata.util.JacksonUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class MetadataServletFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataServletFilter.class);

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String customMetadataStr = httpServletRequest.getHeader("SCT-CUSTOM-METADATA");
        try {
            if (StringUtils.hasText((String)customMetadataStr)) {
                customMetadataStr = URLDecoder.decode(customMetadataStr, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Runtime system does not support utf-8 coding.", (Throwable)e);
        }
        LOG.debug("Get upstream metadata string: {}", (Object)customMetadataStr);
        Map<String, String> upstreamCustomMetadataMap = JacksonUtils.deserialize2Map(customMetadataStr);
        HashMap<String, String> systemMetadataMap = new HashMap<String, String>();
        systemMetadataMap.put("LOCAL_NAMESPACE", MetadataContextHolder.LOCAL_NAMESPACE);
        systemMetadataMap.put("LOCAL_SERVICE", MetadataContextHolder.LOCAL_SERVICE);
        systemMetadataMap.put("LOCAL_PATH", httpServletRequest.getRequestURI());
        try {
            MetadataContextHolder.init(upstreamCustomMetadataMap, systemMetadataMap);
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (IOException | RuntimeException | ServletException e) {
            throw e;
        }
        finally {
            MetadataContextHolder.remove();
        }
    }
}

