/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core.interceptor.feign;

import com.tencent.cloud.metadata.context.MetadataContext;
import com.tencent.cloud.metadata.context.MetadataContextHolder;
import com.tencent.cloud.metadata.util.JacksonUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class Metadata2HeaderFeignInterceptor
implements RequestInterceptor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(Metadata2HeaderFeignInterceptor.class);

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void apply(RequestTemplate requestTemplate) {
        Map<String, String> customMetadata;
        MetadataContext metadataContext = MetadataContextHolder.get();
        if (!CollectionUtils.isEmpty((Map)requestTemplate.headers()) && !CollectionUtils.isEmpty((Collection)((Collection)requestTemplate.headers().get("SCT-CUSTOM-METADATA")))) {
            for (String headerMetadataStr : (Collection)requestTemplate.headers().get("SCT-CUSTOM-METADATA")) {
                Map<String, String> headerMetadataMap = JacksonUtils.deserialize2Map(headerMetadataStr);
                for (String key : headerMetadataMap.keySet()) {
                    metadataContext.putTransitiveCustomMetadata(key, headerMetadataMap.get(key));
                }
            }
        }
        if (!CollectionUtils.isEmpty(customMetadata = metadataContext.getAllTransitiveCustomMetadata())) {
            String metadataStr = JacksonUtils.serialize2Json(customMetadata);
            requestTemplate.removeHeader("SCT-CUSTOM-METADATA");
            try {
                requestTemplate.header("SCT-CUSTOM-METADATA", new String[]{URLEncoder.encode(metadataStr, "UTF-8")});
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Set header failed.", (Throwable)e);
                requestTemplate.header("SCT-CUSTOM-METADATA", new String[]{metadataStr});
            }
        }
    }
}

