/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core.interceptor.resttemplate;

import com.tencent.cloud.metadata.context.MetadataContext;
import com.tencent.cloud.metadata.context.MetadataContextHolder;
import com.tencent.cloud.metadata.util.JacksonUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MetadataRestTemplateInterceptor
implements ClientHttpRequestInterceptor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataRestTemplateInterceptor.class);

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        Map<String, String> customMetadata;
        MetadataContext metadataContext = MetadataContextHolder.get();
        String metadataStr = httpRequest.getHeaders().getFirst("SCT-CUSTOM-METADATA");
        if (!StringUtils.isEmpty((Object)metadataStr)) {
            Map<String, String> headerMetadataMap = JacksonUtils.deserialize2Map(metadataStr);
            for (String key : headerMetadataMap.keySet()) {
                metadataContext.putTransitiveCustomMetadata(key, headerMetadataMap.get(key));
            }
        }
        if (!CollectionUtils.isEmpty(customMetadata = metadataContext.getAllTransitiveCustomMetadata())) {
            metadataStr = JacksonUtils.serialize2Json(customMetadata);
            try {
                httpRequest.getHeaders().set("SCT-CUSTOM-METADATA", URLEncoder.encode(metadataStr, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                httpRequest.getHeaders().set("SCT-CUSTOM-METADATA", metadataStr);
            }
        }
        return clientHttpRequestExecution.execute(httpRequest, bytes);
    }
}

