/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context;

import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.rpc.GetServiceRuleRequest;
import com.tencent.polaris.api.rpc.ServiceRuleResponse;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RoutingProto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRuleManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRuleManager.class);
    private final SDKContext sdkContext;
    private final ConsumerAPI consumerAPI;

    public ServiceRuleManager(SDKContext sdkContext, ConsumerAPI consumerAPI) {
        this.sdkContext = sdkContext;
        this.consumerAPI = consumerAPI;
    }

    public RateLimitProto.RateLimit getServiceRateLimitRule(String namespace, String service) {
        Object rule;
        LOG.debug("Get service rate limit rules with namespace:{} and service:{}.", (Object)namespace, (Object)service);
        ServiceRule serviceRule = this.getServiceRule(namespace, service, ServiceEventKey.EventType.RATE_LIMITING);
        if (serviceRule != null && (rule = serviceRule.getRule()) instanceof RateLimitProto.RateLimit) {
            return (RateLimitProto.RateLimit)rule;
        }
        return null;
    }

    public List<RoutingProto.Route> getServiceRouterRule(String namespace, String sourceService, String dstService) {
        Object rule;
        ServiceRule dstServiceRule;
        Object rule2;
        LOG.debug("Get service router rules with namespace:{} and sourceService:{} and dstService:{}.", new Object[]{namespace, sourceService, dstService});
        ArrayList<RoutingProto.Route> rules = new ArrayList<RoutingProto.Route>();
        ServiceRule sourceServiceRule = this.getServiceRule(namespace, sourceService, ServiceEventKey.EventType.ROUTING);
        if (sourceServiceRule != null && (rule2 = sourceServiceRule.getRule()) instanceof RoutingProto.Routing) {
            rules.addAll(((RoutingProto.Routing)rule2).getOutboundsList());
        }
        if ((dstServiceRule = this.getServiceRule(namespace, dstService, ServiceEventKey.EventType.ROUTING)) != null && (rule = dstServiceRule.getRule()) instanceof RoutingProto.Routing) {
            rules.addAll(((RoutingProto.Routing)rule).getInboundsList());
        }
        return rules;
    }

    public List<CircuitBreakerProto.CircuitBreakerRule> getServiceCircuitBreakerRule(String namespace, String sourceService, String dstService) {
        Object rule;
        ServiceRule dstServiceRule;
        Object rule2;
        LOG.debug("Get service circuit breaker rules with namespace:{} and sourceService:{} and dstService:{}.", new Object[]{namespace, sourceService, dstService});
        ArrayList<CircuitBreakerProto.CircuitBreakerRule> rules = new ArrayList<CircuitBreakerProto.CircuitBreakerRule>();
        ServiceRule sourceServiceRule = this.getServiceRule(namespace, sourceService, ServiceEventKey.EventType.CIRCUIT_BREAKING);
        if (sourceServiceRule != null && (rule2 = sourceServiceRule.getRule()) instanceof CircuitBreakerProto.CircuitBreaker) {
            rules.addAll(((CircuitBreakerProto.CircuitBreaker)rule2).getRulesList());
        }
        if ((dstServiceRule = this.getServiceRule(namespace, dstService, ServiceEventKey.EventType.CIRCUIT_BREAKING)) != null && (rule = dstServiceRule.getRule()) instanceof CircuitBreakerProto.CircuitBreaker) {
            rules.addAll(((CircuitBreakerProto.CircuitBreaker)rule).getRulesList());
        }
        return rules;
    }

    private ServiceRule getServiceRule(String namespace, String service, ServiceEventKey.EventType eventType) {
        GetServiceRuleRequest getServiceRuleRequest = new GetServiceRuleRequest();
        getServiceRuleRequest.setRuleType(eventType);
        getServiceRuleRequest.setService(service);
        getServiceRuleRequest.setTimeoutMs(this.sdkContext.getConfig().getGlobal().getAPI().getTimeout());
        getServiceRuleRequest.setNamespace(namespace);
        ServiceRuleResponse res = this.consumerAPI.getServiceRule(getServiceRuleRequest);
        return res.getServiceRule();
    }
}

