/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context.config;

import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="spring.cloud.polaris")
public class PolarisContextProperties {
    @Value(value="${spring.cloud.polaris.address:}")
    private String address;
    @Value(value="${spring.cloud.polaris.localIpAddress:}")
    private String localIpAddress;
    @Value(value="${spring.cloud.polaris.localPort:}")
    private Integer localPort;
    @Value(value="${spring.cloud.polaris.enabled:#{'true'}}")
    private Boolean enabled;
    @Value(value="${spring.cloud.polaris.namespace:#{'default'}}")
    private String namespace = "default";
    private String service;

    public Configuration configuration(List<PolarisConfigModifier> modifierList, Supplier<String> ipAddressSupplier, Supplier<Integer> portSupplier) {
        ConfigurationImpl configuration = (ConfigurationImpl)ConfigAPIFactory.defaultConfig((String)"default");
        String defaultHost = this.localIpAddress;
        if (StringUtils.isBlank((String)this.localIpAddress)) {
            this.localIpAddress = defaultHost = ipAddressSupplier.get();
        }
        if (this.localPort == null || this.localPort <= 0) {
            this.localPort = portSupplier.get();
        }
        configuration.getGlobal().getAPI().setBindIP(defaultHost);
        Collection<PolarisConfigModifier> modifiers = modifierList;
        modifiers = modifiers.stream().sorted(Comparator.comparingInt(PolarisConfigModifier::getOrder)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(modifiers)) {
            for (PolarisConfigModifier modifier : modifiers) {
                modifier.modify(configuration);
            }
        }
        return configuration;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLocalIpAddress() {
        return this.localIpAddress;
    }

    public void setLocalIpAddress(String localIpAddress) {
        this.localIpAddress = localIpAddress;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String toString() {
        return "PolarisContextProperties{address='" + this.address + "', localIpAddress='" + this.localIpAddress + "'" + (String)(this.localPort == null || this.localPort <= 0 ? "" : ", localPort=" + this.localPort) + ", enabled=" + this.enabled + ", namespace='" + this.namespace + "'" + (String)(StringUtils.isBlank((String)this.service) ? "" : ", service='" + this.service + "'") + "}";
    }
}

