/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context.logging;

import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.PolarisLogging;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.NonNull;

public class PolarisLoggingApplicationListener
implements GenericApplicationListener {
    private static final int ORDER = -2147483626;

    public boolean supportsEventType(ResolvableType resolvableType) {
        Class type = resolvableType.getRawClass();
        if (type == null) {
            return false;
        }
        return ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(type) || ApplicationFailedEvent.class.isAssignableFrom(type);
    }

    public int getOrder() {
        return -2147483626;
    }

    public void onApplicationEvent(@NonNull ApplicationEvent applicationEvent) {
        String loggingPath;
        ConfigurableEnvironment environment = null;
        if (ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(applicationEvent.getClass())) {
            environment = ((ApplicationEnvironmentPreparedEvent)applicationEvent).getEnvironment();
        } else if (ApplicationFailedEvent.class.isAssignableFrom(applicationEvent.getClass())) {
            environment = ((ApplicationFailedEvent)applicationEvent).getApplicationContext().getEnvironment();
        }
        if (environment != null && StringUtils.isNotBlank((String)(loggingPath = environment.getProperty("spring.cloud.polaris.logging.path")))) {
            System.setProperty("polaris.log.home", loggingPath);
        }
        PolarisLogging.getInstance().loadConfiguration();
    }
}

