/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context;

import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="spring.cloud.polaris")
public class PolarisContextProperties {
    private String address;
    @Value(value="${spring.cloud.polaris.local-ip-address:}")
    private String localIpAddress;
    private Boolean enabled;
    private String namespace = "default";
    private String service;
    @Autowired
    private Environment environment;
    @Autowired
    private List<PolarisConfigModifier> modifierList;

    protected Configuration configuration() {
        ConfigurationImpl configuration = (ConfigurationImpl)ConfigAPIFactory.defaultConfig((String)"default");
        configuration.setDefault();
        String defaultHost = this.getHost();
        configuration.getGlobal().getAPI().setBindIP(defaultHost);
        Collection<PolarisConfigModifier> modifiers = this.modifierList;
        modifiers = modifiers.stream().sorted(Comparator.comparingInt(PolarisConfigModifier::getOrder)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(modifiers)) {
            for (PolarisConfigModifier modifier : modifiers) {
                modifier.modify(configuration);
            }
        }
        return configuration;
    }

    private String getHost() {
        if (StringUtils.isNotBlank((String)this.localIpAddress)) {
            return this.localIpAddress;
        }
        return this.environment.getProperty("spring.cloud.client.ip-address");
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    String getLocalIpAddress() {
        return this.localIpAddress;
    }

    void setLocalIpAddress(String localIpAddress) {
        this.localIpAddress = localIpAddress;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    String getService() {
        return this.service;
    }

    void setService(String service) {
        this.service = service;
    }
}

