/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context;

import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.common.metadata.config.MetadataAutoConfiguration;
import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.context.ModifyAddress;
import com.tencent.cloud.polaris.context.PolarisContextProperties;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.client.api.SDKContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnPolarisEnabled
@EnableConfigurationProperties(value={PolarisContextProperties.class})
@ImportAutoConfiguration(value={MetadataAutoConfiguration.class})
public class PolarisContextAutoConfiguration {
    @Bean(name={"polarisContext"}, initMethod="init", destroyMethod="destroy")
    @ConditionalOnMissingBean
    public SDKContext polarisContext(PolarisContextProperties properties, StaticMetadataManager staticMetadataManager) throws PolarisException {
        SDKContext sdkContext = SDKContext.initContextByConfig((Configuration)properties.configuration());
        ValueContext valueContext = sdkContext.getValueContext();
        String region = staticMetadataManager.getRegion();
        String zone = staticMetadataManager.getZone();
        String campus = staticMetadataManager.getCampus();
        if (StringUtils.isNotBlank((String)region)) {
            valueContext.setValue(LocationLevel.region.name(), (Object)region);
        }
        if (StringUtils.isNotBlank((String)zone)) {
            valueContext.setValue(LocationLevel.zone.name(), (Object)zone);
        }
        if (StringUtils.isNotBlank((String)campus)) {
            valueContext.setValue(LocationLevel.campus.name(), (Object)campus);
        }
        return sdkContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public ModifyAddress polarisConfigModifier() {
        return new ModifyAddress();
    }

    @Bean
    public ServiceRuleManager serviceRuleManager(SDKContext sdkContext) {
        return new ServiceRuleManager(sdkContext);
    }
}

