/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context;

import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.DefaultServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.client.pb.RateLimitProto;
import com.tencent.polaris.client.pb.RoutingProto;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRuleManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRuleManager.class);
    private final SDKContext sdkContext;
    private final FlowControlParam controlParam;

    public ServiceRuleManager(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
        this.controlParam = new DefaultFlowControlParam();
        this.controlParam.setTimeoutMs(sdkContext.getConfig().getGlobal().getAPI().getTimeout());
        this.controlParam.setMaxRetry(sdkContext.getConfig().getGlobal().getAPI().getMaxRetryTimes());
        this.controlParam.setRetryIntervalMs(sdkContext.getConfig().getGlobal().getAPI().getRetryInterval());
    }

    public RateLimitProto.RateLimit getServiceRateLimitRule(String namespace, String service) {
        Object rule;
        LOG.debug("Get service rate limit rules with namespace:{} and service:{}.", (Object)namespace, (Object)service);
        ServiceEventKey serviceEventKey = new ServiceEventKey(new ServiceKey(namespace, service), ServiceEventKey.EventType.RATE_LIMITING);
        DefaultServiceEventKeysProvider svcKeysProvider = new DefaultServiceEventKeysProvider();
        svcKeysProvider.setSvcEventKey(serviceEventKey);
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.sdkContext.getExtensions(), (boolean)true, (ServiceEventKeysProvider)svcKeysProvider, (FlowControlParam)this.controlParam);
        ServiceRule serviceRule = resourcesResponse.getServiceRule(serviceEventKey);
        if (serviceRule != null && (rule = serviceRule.getRule()) instanceof RateLimitProto.RateLimit) {
            return (RateLimitProto.RateLimit)rule;
        }
        return null;
    }

    public List<RoutingProto.Route> getServiceRouterRule(String namespace, String sourceService, String dstService) {
        Object rule;
        ServiceRule dstServiceRule;
        Object rule2;
        LOG.debug("Get service router rules with namespace:{} and sourceService:{} and dstService:{}.", new Object[]{namespace, sourceService, dstService});
        HashSet<ServiceEventKey> routerKeys = new HashSet<ServiceEventKey>();
        ServiceEventKey dstSvcEventKey = new ServiceEventKey(new ServiceKey(namespace, dstService), ServiceEventKey.EventType.ROUTING);
        routerKeys.add(dstSvcEventKey);
        ServiceEventKey srcSvcEventKey = new ServiceEventKey(new ServiceKey(namespace, sourceService), ServiceEventKey.EventType.ROUTING);
        routerKeys.add(srcSvcEventKey);
        DefaultServiceEventKeysProvider svcKeysProvider = new DefaultServiceEventKeysProvider();
        svcKeysProvider.setSvcEventKeys(routerKeys);
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)this.sdkContext.getExtensions(), (boolean)true, (ServiceEventKeysProvider)svcKeysProvider, (FlowControlParam)this.controlParam);
        ArrayList<RoutingProto.Route> rules = new ArrayList<RoutingProto.Route>();
        ServiceRule sourceServiceRule = resourcesResponse.getServiceRule(srcSvcEventKey);
        if (sourceServiceRule != null && (rule2 = sourceServiceRule.getRule()) instanceof RoutingProto.Routing) {
            rules.addAll(((RoutingProto.Routing)rule2).getOutboundsList());
        }
        if ((dstServiceRule = resourcesResponse.getServiceRule(dstSvcEventKey)) != null && (rule = dstServiceRule.getRule()) instanceof RoutingProto.Routing) {
            rules.addAll(((RoutingProto.Routing)rule).getInboundsList());
        }
        return rules;
    }
}

