/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.context.config;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.context.ModifyAddress;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnPolarisEnabled
@EnableConfigurationProperties(value={PolarisContextProperties.class})
public class PolarisContextAutoConfiguration {
    @Bean(name={"polarisContext"}, initMethod="init", destroyMethod="destroy")
    @ConditionalOnMissingBean
    public SDKContext polarisContext(PolarisContextProperties properties, Environment environment, List<PolarisConfigModifier> modifierList) throws PolarisException {
        return SDKContext.initContextByConfig((Configuration)properties.configuration(modifierList, () -> environment.getProperty("spring.cloud.client.ip-address")));
    }

    @Bean
    @ConditionalOnMissingBean
    public ProviderAPI polarisProvider(SDKContext polarisContext) throws PolarisException {
        return DiscoveryAPIFactory.createProviderAPIByContext((SDKContext)polarisContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsumerAPI polarisConsumer(SDKContext polarisContext) throws PolarisException {
        return DiscoveryAPIFactory.createConsumerAPIByContext((SDKContext)polarisContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public ModifyAddress polarisConfigModifier(PolarisContextProperties properties) {
        return new ModifyAddress(properties);
    }

    @Bean
    public ServiceRuleManager serviceRuleManager(SDKContext sdkContext) {
        return new ServiceRuleManager(sdkContext);
    }
}

