/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.DefaultServiceInstances;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cloud.client.ServiceInstance;
import reactor.core.publisher.Flux;

public class LoadBalancerUtils {
    public static ServiceInstances transferServersToServiceInstances(Flux<List<ServiceInstance>> servers) {
        List instances = servers.toStream().flatMap(Collection::stream).map(serviceInstance -> {
            DefaultInstance instance = new DefaultInstance();
            instance.setNamespace(MetadataContext.LOCAL_NAMESPACE);
            instance.setService(serviceInstance.getServiceId());
            instance.setProtocol(serviceInstance.getScheme());
            instance.setId(serviceInstance.getInstanceId());
            instance.setHost(serviceInstance.getHost());
            instance.setPort(serviceInstance.getPort());
            instance.setWeight(100);
            instance.setMetadata(serviceInstance.getMetadata());
            return instance;
        }).collect(Collectors.toList());
        String serviceName = null;
        if (CollectionUtils.isNotEmpty(instances)) {
            serviceName = ((Instance)instances.get(0)).getService();
        }
        ServiceKey serviceKey = new ServiceKey(MetadataContext.LOCAL_NAMESPACE, serviceName);
        return new DefaultServiceInstances(serviceKey, instances);
    }
}

