/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer.config;

import com.tencent.cloud.polaris.loadbalancer.PolarisLoadBalancer;
import com.tencent.cloud.polaris.loadbalancer.PolarisServiceInstanceListSupplier;
import com.tencent.cloud.polaris.loadbalancer.config.PolarisLoadBalancerProperties;
import com.tencent.polaris.router.api.core.RouterAPI;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
public class PolarisLoadBalancerClientConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;
    private static final String STRATEGY_WEIGHT = "polarisWeighted";

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.strategy"}, havingValue="polarisWeighted")
    public ReactorLoadBalancer<ServiceInstance> polarisLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, PolarisLoadBalancerProperties loadBalancerProperties, RouterAPI routerAPI) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new PolarisLoadBalancer(name, (ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), loadBalancerProperties, routerAPI);
    }

    @Configuration
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=193827466)
    static class PolarisBlockingSupportConfiguration {
        PolarisBlockingSupportConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="polaris")
        public ServiceInstanceListSupplier polarisRouterDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new PolarisServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().build(context));
        }
    }

    @Configuration
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=193827465)
    static class PolarisReactiveSupportConfiguration {
        PolarisReactiveSupportConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="polaris")
        public ServiceInstanceListSupplier polarisRouterDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new PolarisServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().build(context));
        }
    }
}

