/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.pojo.PolarisServiceInstance;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.DefaultServiceInstances;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public final class LoadBalancerUtils {
    private LoadBalancerUtils() {
    }

    public static ServiceInstances transferServersToServiceInstances(Flux<List<ServiceInstance>> servers) {
        AtomicReference instances = new AtomicReference();
        servers.subscribe(serviceInstances -> instances.set(serviceInstances.stream().map(serviceInstance -> {
            DefaultInstance instance = new DefaultInstance();
            instance.setNamespace(MetadataContext.LOCAL_NAMESPACE);
            instance.setService(serviceInstance.getServiceId());
            instance.setProtocol(serviceInstance.getScheme());
            instance.setId(serviceInstance.getInstanceId());
            instance.setHost(serviceInstance.getHost());
            instance.setPort(serviceInstance.getPort());
            instance.setWeight(100);
            instance.setMetadata(serviceInstance.getMetadata());
            if (serviceInstance instanceof PolarisServiceInstance) {
                PolarisServiceInstance polarisServiceInstance = (PolarisServiceInstance)serviceInstance;
                instance.setRegion(polarisServiceInstance.getPolarisInstance().getRegion());
                instance.setZone(polarisServiceInstance.getPolarisInstance().getZone());
                instance.setCampus(polarisServiceInstance.getPolarisInstance().getCampus());
            }
            return instance;
        }).collect(Collectors.toList())));
        String serviceName = null;
        if (CollectionUtils.isEmpty((Collection)((Collection)instances.get()))) {
            instances.set(Collections.emptyList());
        } else {
            serviceName = ((Instance)((List)instances.get()).get(0)).getService();
        }
        ServiceKey serviceKey = new ServiceKey(MetadataContext.LOCAL_NAMESPACE, serviceName);
        return new DefaultServiceInstances(serviceKey, (List)instances.get());
    }
}

