/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.pojo.PolarisServiceInstance;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.Instance;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class PolarisServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    public PolarisServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        super(delegate);
    }

    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.getDelegate().get()).map(this::chooseInstances);
    }

    public Flux<List<ServiceInstance>> get(Request request) {
        return super.get(request);
    }

    public List<ServiceInstance> chooseInstances(List<ServiceInstance> allServers) {
        if (CollectionUtils.isEmpty(allServers)) {
            return allServers;
        }
        String serviceName = allServers.get(0).getServiceId();
        if (StringUtils.isBlank((String)serviceName)) {
            throw new IllegalStateException("PolarisRoutingLoadBalancer only Server with AppName or ServiceIdForDiscovery attribute");
        }
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>(allServers.size());
        for (ServiceInstance server : allServers) {
            DefaultInstance instance = new DefaultInstance();
            instance.setNamespace(MetadataContext.LOCAL_NAMESPACE);
            instance.setService(serviceName);
            instance.setProtocol(server.getScheme());
            instance.setId(server.getInstanceId());
            instance.setHost(server.getHost());
            instance.setPort(server.getPort());
            instance.setWeight(100);
            instance.setMetadata(server.getMetadata());
            serviceInstances.add((ServiceInstance)new PolarisServiceInstance((Instance)instance));
        }
        return serviceInstances;
    }
}

