/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.pojo.PolarisServiceInstance;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.DefaultServiceInstances;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public final class LoadBalancerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancerUtils.class);
    private static final int WAIT_TIME = 3;

    private LoadBalancerUtils() {
    }

    public static ServiceInstances transferServersToServiceInstances(Flux<List<ServiceInstance>> servers) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference instancesRef = new AtomicReference();
        servers.subscribe(serviceInstances -> {
            instancesRef.set(serviceInstances.stream().map(LoadBalancerUtils::transferServerToServiceInstance).collect(Collectors.toList()));
            latch.countDown();
        });
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Wait get instance result error. ", (Throwable)e);
        }
        String serviceName = "";
        if (!CollectionUtils.isEmpty((Collection)((Collection)instancesRef.get()))) {
            serviceName = ((Instance)((List)instancesRef.get()).get(0)).getService();
        }
        ServiceKey serviceKey = new ServiceKey(MetadataContext.LOCAL_NAMESPACE, serviceName);
        List instances = instancesRef.get() == null ? Collections.emptyList() : (List)instancesRef.get();
        return new DefaultServiceInstances(serviceKey, instances);
    }

    public static DefaultInstance transferServerToServiceInstance(ServiceInstance serviceInstance) {
        DefaultInstance instance = new DefaultInstance();
        instance.setNamespace(MetadataContext.LOCAL_NAMESPACE);
        instance.setService(serviceInstance.getServiceId());
        instance.setProtocol(serviceInstance.getScheme());
        instance.setId(serviceInstance.getInstanceId());
        instance.setHost(serviceInstance.getHost());
        instance.setPort(serviceInstance.getPort());
        instance.setMetadata(serviceInstance.getMetadata());
        if (serviceInstance instanceof PolarisServiceInstance) {
            PolarisServiceInstance polarisServiceInstance = (PolarisServiceInstance)serviceInstance;
            instance.setRegion(polarisServiceInstance.getPolarisInstance().getRegion());
            instance.setZone(polarisServiceInstance.getPolarisInstance().getZone());
            instance.setCampus(polarisServiceInstance.getPolarisInstance().getCampus());
            instance.setWeight(polarisServiceInstance.getPolarisInstance().getWeight());
        }
        return instance;
    }
}

