/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.pojo.PolarisServiceInstance;
import com.tencent.cloud.polaris.loadbalancer.config.PolarisLoadBalancerProperties;
import com.tencent.polaris.api.pojo.DefaultServiceInstances;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.router.api.core.RouterAPI;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceRequest;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class PolarisLoadBalancer
extends RoundRobinLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisLoadBalancer.class);
    private final String serviceId;
    private final PolarisLoadBalancerProperties loadBalancerProperties;
    private final RouterAPI routerAPI;
    private final ObjectProvider<ServiceInstanceListSupplier> supplierObjectProvider;

    public PolarisLoadBalancer(String serviceId, ObjectProvider<ServiceInstanceListSupplier> supplierObjectProvider, PolarisLoadBalancerProperties loadBalancerProperties, RouterAPI routerAPI) {
        super(supplierObjectProvider, serviceId);
        this.serviceId = serviceId;
        this.supplierObjectProvider = supplierObjectProvider;
        this.loadBalancerProperties = loadBalancerProperties;
        this.routerAPI = routerAPI;
    }

    private static ServiceInstances convertToPolarisServiceInstances(List<ServiceInstance> serviceInstances) {
        ServiceKey serviceKey = new ServiceKey(MetadataContext.LOCAL_NAMESPACE, serviceInstances.get(0).getServiceId());
        List polarisInstances = serviceInstances.stream().map(serviceInstance -> ((PolarisServiceInstance)serviceInstance).getPolarisInstance()).collect(Collectors.toList());
        return new DefaultServiceInstances(serviceKey, polarisInstances);
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        if (!this.loadBalancerProperties.getEnabled().booleanValue()) {
            return super.choose(request);
        }
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.supplierObjectProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(this::getInstanceResponse);
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            LOGGER.warn("No servers available for service: " + this.serviceId);
            return new EmptyResponse();
        }
        ProcessLoadBalanceRequest request = new ProcessLoadBalanceRequest();
        request.setDstInstances(PolarisLoadBalancer.convertToPolarisServiceInstances(serviceInstances));
        request.setLbPolicy("weightedRandom");
        request.setCriteria(new Criteria());
        try {
            ProcessLoadBalanceResponse response = this.routerAPI.processLoadBalance(request);
            return new DefaultResponse((ServiceInstance)new PolarisServiceInstance(response.getTargetInstance()));
        }
        catch (Exception e) {
            LOGGER.warn("PolarisRoutingLoadbalancer error", (Throwable)e);
            return new EmptyResponse();
        }
    }
}

