/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.plugin.pushgateway;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.plugin.pushgateway.PolarisStatPushGatewayProperties;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.plugins.stat.pushgateway.handler.PrometheusPushHandlerConfig;
import org.springframework.core.env.Environment;

public class PolarisStatPushGatewayModifier
implements PolarisConfigModifier {
    private static final String POLARIS_STAT_ENABLED = "spring.cloud.polaris.stat.enabled";
    private static final String PROMETHEUS_PUSH_GATEWAY_PLUGIN_NAME = "prometheus-pushgateway";
    private final PolarisStatPushGatewayProperties polarisStatPushGatewayProperties;
    private final Environment environment;

    public PolarisStatPushGatewayModifier(PolarisStatPushGatewayProperties polarisStatPushGatewayProperties, Environment environment) {
        this.polarisStatPushGatewayProperties = polarisStatPushGatewayProperties;
        this.environment = environment;
    }

    public void modify(ConfigurationImpl configuration) {
        Boolean statEnabled = (Boolean)this.environment.getProperty(POLARIS_STAT_ENABLED, Boolean.class, (Object)false);
        if (!statEnabled.booleanValue()) {
            configuration.getGlobal().getStatReporter().setEnable(this.polarisStatPushGatewayProperties.isEnabled());
        }
        if (this.polarisStatPushGatewayProperties.isEnabled()) {
            PrometheusPushHandlerConfig prometheusHandlerConfig = (PrometheusPushHandlerConfig)configuration.getGlobal().getStatReporter().getPluginConfig(PROMETHEUS_PUSH_GATEWAY_PLUGIN_NAME, PrometheusPushHandlerConfig.class);
            prometheusHandlerConfig.setPushgatewayAddress(this.polarisStatPushGatewayProperties.getAddress());
            prometheusHandlerConfig.setPushInterval(this.polarisStatPushGatewayProperties.getPushInterval());
            configuration.getGlobal().getStatReporter().setPluginConfig(PROMETHEUS_PUSH_GATEWAY_PLUGIN_NAME, (Verifier)prometheusHandlerConfig);
        }
    }

    public int getOrder() {
        return ContextConstant.ModifierOrder.STAT_REPORTER_ORDER + 1;
    }
}

