/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.config;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.context.config.PolarisContextAutoConfiguration;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.feign.EnhancedFeignBeanPostProcessor;
import com.tencent.cloud.rpc.enhancement.plugin.DefaultEnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPlugin;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.reporter.ExceptionPolarisReporter;
import com.tencent.cloud.rpc.enhancement.plugin.reporter.SuccessPolarisReporter;
import com.tencent.cloud.rpc.enhancement.resttemplate.BlockingLoadBalancerClientAspect;
import com.tencent.cloud.rpc.enhancement.resttemplate.EnhancedRestTemplateInterceptor;
import com.tencent.cloud.rpc.enhancement.scg.EnhancedGatewayGlobalFilter;
import com.tencent.cloud.rpc.enhancement.webclient.EnhancedWebClientReporter;
import com.tencent.cloud.rpc.enhancement.webclient.PolarisLoadBalancerClientRequestTransformer;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.client.api.SDKContext;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisEnabled
@ConditionalOnProperty(value={"spring.cloud.tencent.rpc-enhancement.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={RpcEnhancementReporterProperties.class})
@AutoConfigureAfter(value={PolarisContextAutoConfiguration.class})
public class RpcEnhancementAutoConfiguration {
    @Bean
    public EnhancedPluginRunner enhancedFeignPluginRunner(@Autowired(required=false) List<EnhancedPlugin> enhancedPlugins) {
        return new DefaultEnhancedPluginRunner(enhancedPlugins);
    }

    @Bean
    public SuccessPolarisReporter successPolarisReporter(RpcEnhancementReporterProperties properties, SDKContext context, ConsumerAPI consumerAPI) {
        return new SuccessPolarisReporter(properties, context, consumerAPI);
    }

    @Bean
    public ExceptionPolarisReporter exceptionPolarisReporter(RpcEnhancementReporterProperties properties, SDKContext context, ConsumerAPI consumerAPI) {
        return new ExceptionPolarisReporter(properties, context, consumerAPI);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.gateway.config.GatewayAutoConfiguration"})
    @Role(value=2)
    protected static class PolarisGatewayAutoConfiguration {
        protected PolarisGatewayAutoConfiguration() {
        }

        @Bean
        @ConditionalOnClass(name={"org.springframework.cloud.gateway.filter.GlobalFilter"})
        public EnhancedGatewayGlobalFilter enhancedPolarisGatewayReporter(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedGatewayGlobalFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    protected static class PolarisWebClientAutoConfiguration {
        @Autowired(required=false)
        private List<WebClient.Builder> webClientBuilder = Collections.emptyList();

        protected PolarisWebClientAutoConfiguration() {
        }

        @Bean
        public EnhancedWebClientReporter exchangeFilterFunction(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedWebClientReporter(pluginRunner);
        }

        @Bean
        public SmartInitializingSingleton addEnhancedWebClientReporterForWebClient(EnhancedWebClientReporter reporter) {
            return () -> this.webClientBuilder.forEach(webClient -> webClient.filter((ExchangeFilterFunction)reporter));
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer"})
        public PolarisLoadBalancerClientRequestTransformer polarisLoadBalancerClientRequestTransformer() {
            return new PolarisLoadBalancerClientRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    protected static class PolarisRestTemplateAutoConfiguration {
        @LoadBalanced
        @Autowired(required=false)
        private List<RestTemplate> restTemplates = Collections.emptyList();

        protected PolarisRestTemplateAutoConfiguration() {
        }

        @Bean
        public EnhancedRestTemplateInterceptor enhancedPolarisRestTemplateReporter(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedRestTemplateInterceptor(pluginRunner);
        }

        @Bean
        public SmartInitializingSingleton setPolarisReporterForRestTemplate(EnhancedRestTemplateInterceptor reporter) {
            return () -> {
                for (RestTemplate restTemplate : this.restTemplates) {
                    restTemplate.getInterceptors().add(reporter);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient"})
        public BlockingLoadBalancerClientAspect blockingLoadBalancerClientAspect() {
            return new BlockingLoadBalancerClientAspect();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @AutoConfigureBefore(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @Role(value=2)
    protected static class PolarisFeignClientAutoConfiguration {
        protected PolarisFeignClientAutoConfiguration() {
        }

        @Bean
        public EnhancedFeignBeanPostProcessor polarisFeignBeanPostProcessor(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedFeignBeanPostProcessor(pluginRunner);
        }
    }
}

