/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.plugin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPlugin;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class DefaultEnhancedPluginRunner
implements EnhancedPluginRunner {
    private final Multimap<String, EnhancedPlugin> pluginMap = ArrayListMultimap.create();

    public DefaultEnhancedPluginRunner(List<EnhancedPlugin> enhancedPlugins) {
        if (!CollectionUtils.isEmpty(enhancedPlugins)) {
            enhancedPlugins.stream().sorted(Comparator.comparing(Ordered::getOrder)).forEach(plugin -> this.pluginMap.put((Object)plugin.getType().name(), plugin));
        }
    }

    @Override
    public void run(EnhancedPluginType pluginType, EnhancedPluginContext context) {
        for (EnhancedPlugin plugin : this.pluginMap.get((Object)pluginType.name())) {
            try {
                plugin.run(context);
            }
            catch (Throwable throwable) {
                plugin.handlerThrowable(context, throwable);
            }
        }
    }
}

