/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.plugin.reporter;

import com.tencent.cloud.rpc.enhancement.AbstractPolarisReporterAdapter;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPlugin;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.client.api.SDKContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class ExceptionPolarisReporter
extends AbstractPolarisReporterAdapter
implements EnhancedPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionPolarisReporter.class);
    private final ConsumerAPI consumerAPI;

    public ExceptionPolarisReporter(RpcEnhancementReporterProperties reporterProperties, SDKContext context, ConsumerAPI consumerAPI) {
        super(reporterProperties, context);
        this.consumerAPI = consumerAPI;
    }

    @Override
    public String getName() {
        return ExceptionPolarisReporter.class.getName();
    }

    @Override
    public EnhancedPluginType getType() {
        return EnhancedPluginType.EXCEPTION;
    }

    @Override
    public void run(EnhancedPluginContext context) {
        if (!this.reportProperties.isEnabled()) {
            return;
        }
        EnhancedRequestContext request = context.getRequest();
        ServiceInstance serviceInstance = Optional.ofNullable(context.getServiceInstance()).orElse((ServiceInstance)new DefaultServiceInstance());
        ServiceCallResult resultRequest = this.createServiceCallResult(serviceInstance.getServiceId(), serviceInstance.getHost(), serviceInstance.getPort(), request.getUrl(), request.getHttpHeaders(), null, null, context.getDelay(), context.getThrowable());
        LOG.debug("Will report ServiceCallResult of {}. Request=[{} {}]. Response=[{}]. Delay=[{}]ms.", new Object[]{resultRequest.getRetStatus().name(), request.getHttpMethod().name(), request.getUrl().getPath(), context.getThrowable().getMessage(), context.getDelay()});
        this.consumerAPI.updateServiceCallResult(resultRequest);
    }

    @Override
    public void handlerThrowable(EnhancedPluginContext context, Throwable throwable) {
        LOG.error("ExceptionPolarisReporter runs failed. context=[{}].", (Object)context, (Object)throwable);
    }

    public int getOrder() {
        return -2147483647;
    }
}

