/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.filter;

import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class EnhancedReactiveFilter
implements WebFilter,
Ordered {
    private final EnhancedPluginRunner pluginRunner;

    public EnhancedReactiveFilter(EnhancedPluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        EnhancedPluginContext enhancedPluginContext = new EnhancedPluginContext();
        EnhancedRequestContext enhancedRequestContext = EnhancedRequestContext.builder().httpHeaders(exchange.getRequest().getHeaders()).httpMethod(exchange.getRequest().getMethod()).url(exchange.getRequest().getURI()).build();
        enhancedPluginContext.setRequest(enhancedRequestContext);
        enhancedPluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        this.pluginRunner.run(EnhancedPluginType.Server.PRE, enhancedPluginContext);
        long startMillis = System.currentTimeMillis();
        return chain.filter(exchange).doOnSuccess(v -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            EnhancedResponseContext enhancedResponseContext = EnhancedResponseContext.builder().httpStatus(exchange.getResponse().getRawStatusCode()).httpHeaders(exchange.getResponse().getHeaders()).build();
            enhancedPluginContext.setResponse(enhancedResponseContext);
            this.pluginRunner.run(EnhancedPluginType.Server.POST, enhancedPluginContext);
        }).doOnError(e -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            enhancedPluginContext.setThrowable((Throwable)e);
            this.pluginRunner.run(EnhancedPluginType.Server.EXCEPTION, enhancedPluginContext);
        }).doFinally(v -> this.pluginRunner.run(EnhancedPluginType.Server.FINALLY, enhancedPluginContext));
    }

    public int getOrder() {
        return -2147483638;
    }
}

