/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.filter;

import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-2147483638)
public class EnhancedServletFilter
extends OncePerRequestFilter {
    private final EnhancedPluginRunner pluginRunner;

    public EnhancedServletFilter(EnhancedPluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        EnhancedPluginContext enhancedPluginContext = new EnhancedPluginContext();
        HttpHeaders requestHeaders = new HttpHeaders();
        Enumeration requestHeaderNames = request.getHeaderNames();
        if (requestHeaderNames != null) {
            while (requestHeaderNames.hasMoreElements()) {
                String requestHeaderName = (String)requestHeaderNames.nextElement();
                requestHeaders.addAll(requestHeaderName, Collections.list(request.getHeaders(requestHeaderName)));
            }
        }
        EnhancedRequestContext enhancedRequestContext = EnhancedRequestContext.builder().httpHeaders(requestHeaders).httpMethod(HttpMethod.valueOf((String)request.getMethod())).url(URI.create(request.getRequestURL().toString())).build();
        enhancedPluginContext.setRequest(enhancedRequestContext);
        enhancedPluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        this.pluginRunner.run(EnhancedPluginType.Server.PRE, enhancedPluginContext);
        long startMillis = System.currentTimeMillis();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            HttpHeaders responseHeaders = new HttpHeaders();
            Collection responseHeaderNames = response.getHeaderNames();
            if (responseHeaderNames != null) {
                for (String responseHeaderName : responseHeaderNames) {
                    responseHeaders.addAll(responseHeaderName, new ArrayList(response.getHeaders(responseHeaderName)));
                }
            }
            EnhancedResponseContext enhancedResponseContext = EnhancedResponseContext.builder().httpStatus(response.getStatus()).httpHeaders(responseHeaders).build();
            enhancedPluginContext.setResponse(enhancedResponseContext);
            this.pluginRunner.run(EnhancedPluginType.Server.POST, enhancedPluginContext);
        }
        catch (IOException | ServletException e) {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            enhancedPluginContext.setThrowable(e);
            this.pluginRunner.run(EnhancedPluginType.Server.EXCEPTION, enhancedPluginContext);
            throw e;
        }
        finally {
            this.pluginRunner.run(EnhancedPluginType.Server.FINALLY, enhancedPluginContext);
        }
    }
}

