/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.plugin.assembly;

import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.RequestContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;

public class AssemblyRequestContext
implements RequestContext {
    private final EnhancedRequestContext requestContext;
    private final ServiceKey callerService;
    private final String callerIp;
    private final Map<String, String> cookies;

    public AssemblyRequestContext(EnhancedRequestContext requestContext, ServiceKey callerService, String callerIp) {
        this.requestContext = requestContext;
        this.callerService = callerService;
        this.callerIp = callerIp;
        this.cookies = new HashMap<String, String>();
        List<String> allCookies = ((List)Optional.ofNullable(requestContext.getHttpHeaders().get((Object)"Cookie")).orElse(new ArrayList())).stream().flatMap(it -> Arrays.stream(it.split(";"))).collect(Collectors.toList());
        allCookies.forEach(cookie -> {
            String[] cookieKV = cookie.split("=");
            if (cookieKV.length == 2) {
                this.cookies.put(cookieKV[0], cookieKV[1]);
            }
        });
    }

    public String getMethod() {
        return this.requestContext.getHttpMethod().name();
    }

    public void setMethod(String method) {
        this.requestContext.setHttpMethod(HttpMethod.valueOf((String)method));
    }

    public String getHeader(String key) {
        return this.requestContext.getHttpHeaders().getFirst(key);
    }

    public void setHeader(String key, String value) {
        this.requestContext.getHttpHeaders().set(key, value);
    }

    public Collection<String> listHeaderKeys() {
        return this.requestContext.getHttpHeaders().keySet();
    }

    public String getCookie(String key) {
        return this.cookies.get(key);
    }

    public void setCookie(String key, String value) {
        this.cookies.put(key, value);
    }

    public Collection<String> listCookieKeys() {
        return this.cookies.keySet();
    }

    public String getCallerIp() {
        return this.callerIp;
    }

    public ServiceKey getCallerService() {
        return this.callerService;
    }

    public URI getURI() {
        return this.requestContext.getUrl();
    }
}

