/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.plugin.reporter;

import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPlugin;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import com.tencent.cloud.rpc.enhancement.plugin.PolarisEnhancedPluginUtils;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class SuccessPolarisReporter
implements EnhancedPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessPolarisReporter.class);
    private final ConsumerAPI consumerAPI;
    private final RpcEnhancementReporterProperties reportProperties;

    public SuccessPolarisReporter(RpcEnhancementReporterProperties reportProperties, ConsumerAPI consumerAPI) {
        this.reportProperties = reportProperties;
        this.consumerAPI = consumerAPI;
    }

    @Override
    public String getName() {
        return SuccessPolarisReporter.class.getName();
    }

    @Override
    public EnhancedPluginType getType() {
        return EnhancedPluginType.Client.POST;
    }

    @Override
    public void run(EnhancedPluginContext context) {
        if (!this.reportProperties.isEnabled()) {
            return;
        }
        EnhancedRequestContext request = context.getRequest();
        EnhancedResponseContext response = context.getResponse();
        ServiceInstance callerServiceInstance = Optional.ofNullable(context.getLocalServiceInstance()).orElse((ServiceInstance)new DefaultServiceInstance());
        ServiceInstance calleeServiceInstance = Optional.ofNullable(context.getTargetServiceInstance()).orElse((ServiceInstance)new DefaultServiceInstance());
        ServiceCallResult resultRequest = PolarisEnhancedPluginUtils.createServiceCallResult(callerServiceInstance.getHost(), calleeServiceInstance.getServiceId(), calleeServiceInstance.getHost(), calleeServiceInstance.getPort(), request.getUrl(), request.getHttpHeaders(), response.getHttpHeaders(), response.getHttpStatus(), context.getDelay(), null);
        LOG.debug("Will report ServiceCallResult of {}. Request=[{} {}]. Response=[{}]. Delay=[{}]ms.", new Object[]{resultRequest.getRetStatus().name(), request.getHttpMethod().name(), request.getUrl().getPath(), response.getHttpStatus(), context.getDelay()});
        this.consumerAPI.updateServiceCallResult(resultRequest);
    }

    @Override
    public void handlerThrowable(EnhancedPluginContext context, Throwable throwable) {
        LOG.error("SuccessPolarisReporter runs failed. context=[{}].", (Object)context, (Object)throwable);
    }

    public int getOrder() {
        return -2147483647;
    }
}

