/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.stat.config;

import com.tencent.cloud.common.constant.OrderConstant;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.rpc.enhancement.stat.config.PolarisStatProperties;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusHandlerConfig;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class StatConfigModifier
implements PolarisConfigModifier {
    private final PolarisStatProperties polarisStatProperties;
    private final Environment environment;

    public StatConfigModifier(PolarisStatProperties polarisStatProperties, Environment environment) {
        this.polarisStatProperties = polarisStatProperties;
        this.environment = environment;
    }

    public void modify(ConfigurationImpl configuration) {
        configuration.getGlobal().getStatReporter().setEnable(this.polarisStatProperties.isEnabled());
        PrometheusHandlerConfig prometheusHandlerConfig = (PrometheusHandlerConfig)configuration.getGlobal().getStatReporter().getPluginConfig("prometheus", PrometheusHandlerConfig.class);
        if (this.polarisStatProperties.isEnabled()) {
            if (this.polarisStatProperties.isPushGatewayEnabled()) {
                prometheusHandlerConfig.setType("push");
                prometheusHandlerConfig.setAddress(this.polarisStatProperties.getPushGatewayAddress());
                prometheusHandlerConfig.setPushInterval(this.polarisStatProperties.getPushGatewayPushInterval());
            } else {
                prometheusHandlerConfig.setType("pull");
                if (!StringUtils.hasText((String)this.polarisStatProperties.getHost())) {
                    this.polarisStatProperties.setHost(this.environment.getProperty("spring.cloud.client.ip-address"));
                }
                prometheusHandlerConfig.setHost(this.polarisStatProperties.getHost());
                prometheusHandlerConfig.setPort(Integer.valueOf(this.polarisStatProperties.getPort()));
                prometheusHandlerConfig.setPath(this.polarisStatProperties.getPath());
            }
        } else {
            prometheusHandlerConfig.setPort(Integer.valueOf(-1));
        }
        configuration.getGlobal().getStatReporter().setPluginConfig("prometheus", (Verifier)prometheusHandlerConfig);
    }

    public int getOrder() {
        return OrderConstant.Modifier.STAT_REPORTER_ORDER;
    }
}

