/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.config;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.context.PolarisSDKContextManager;
import com.tencent.cloud.polaris.context.config.PolarisContextAutoConfiguration;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.feign.EnhancedFeignBeanPostProcessor;
import com.tencent.cloud.rpc.enhancement.feign.PolarisLoadBalancerFeignRequestTransformer;
import com.tencent.cloud.rpc.enhancement.filter.EnhancedReactiveFilter;
import com.tencent.cloud.rpc.enhancement.filter.EnhancedServletFilter;
import com.tencent.cloud.rpc.enhancement.plugin.DefaultEnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPlugin;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.reporter.ExceptionPolarisReporter;
import com.tencent.cloud.rpc.enhancement.plugin.reporter.SuccessPolarisReporter;
import com.tencent.cloud.rpc.enhancement.resttemplate.EnhancedRestTemplateInterceptor;
import com.tencent.cloud.rpc.enhancement.resttemplate.PolarisLoadBalancerRequestTransformer;
import com.tencent.cloud.rpc.enhancement.scg.EnhancedGatewayGlobalFilter;
import com.tencent.cloud.rpc.enhancement.transformer.InstanceTransformer;
import com.tencent.cloud.rpc.enhancement.transformer.PolarisInstanceTransformer;
import com.tencent.cloud.rpc.enhancement.webclient.EnhancedWebClientExchangeFilterFunction;
import com.tencent.cloud.rpc.enhancement.webclient.PolarisLoadBalancerClientRequestTransformer;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisEnabled
@ConditionalOnProperty(value={"spring.cloud.tencent.rpc-enhancement.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={RpcEnhancementReporterProperties.class})
@AutoConfigureAfter(value={PolarisContextAutoConfiguration.class})
public class RpcEnhancementAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"com.alibaba.cloud.nacos.NacosServiceInstance"})
    public InstanceTransformer instanceTransformer() {
        return new PolarisInstanceTransformer();
    }

    @Bean
    @Lazy
    public EnhancedPluginRunner enhancedFeignPluginRunner(@Autowired(required=false) List<EnhancedPlugin> enhancedPlugins, @Autowired(required=false) Registration registration, PolarisSDKContextManager polarisSDKContextManager) {
        return new DefaultEnhancedPluginRunner(enhancedPlugins, registration, polarisSDKContextManager.getSDKContext());
    }

    @Bean
    public SuccessPolarisReporter successPolarisReporter(RpcEnhancementReporterProperties properties, PolarisSDKContextManager polarisSDKContextManager) {
        return new SuccessPolarisReporter(properties, polarisSDKContextManager.getConsumerAPI());
    }

    @Bean
    public ExceptionPolarisReporter exceptionPolarisReporter(RpcEnhancementReporterProperties properties, PolarisSDKContextManager polarisSDKContextManager) {
        return new ExceptionPolarisReporter(properties, polarisSDKContextManager.getConsumerAPI());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.gateway.config.GatewayAutoConfiguration"})
    @Role(value=2)
    protected static class PolarisGatewayAutoConfiguration {
        protected PolarisGatewayAutoConfiguration() {
        }

        @Bean
        @ConditionalOnClass(name={"org.springframework.cloud.gateway.filter.GlobalFilter"})
        public EnhancedGatewayGlobalFilter enhancedPolarisGatewayReporter(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedGatewayGlobalFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    protected static class PolarisWebClientAutoConfiguration {
        @Autowired(required=false)
        private List<WebClient.Builder> webClientBuilder = Collections.emptyList();

        protected PolarisWebClientAutoConfiguration() {
        }

        @Bean
        public EnhancedWebClientExchangeFilterFunction exchangeFilterFunction(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedWebClientExchangeFilterFunction(pluginRunner);
        }

        @Bean
        public SmartInitializingSingleton addEnhancedWebClientReporterForWebClient(EnhancedWebClientExchangeFilterFunction reporter) {
            return () -> this.webClientBuilder.forEach(webClient -> webClient.filter((ExchangeFilterFunction)reporter));
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer"})
        public PolarisLoadBalancerClientRequestTransformer polarisLoadBalancerClientRequestTransformer() {
            return new PolarisLoadBalancerClientRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    protected static class PolarisRestTemplateAutoConfiguration {
        @Autowired(required=false)
        private List<RestTemplate> restTemplates = Collections.emptyList();

        protected PolarisRestTemplateAutoConfiguration() {
        }

        @Bean
        public EnhancedRestTemplateInterceptor enhancedPolarisRestTemplateReporter(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedRestTemplateInterceptor(pluginRunner);
        }

        @Bean
        public SmartInitializingSingleton setPolarisReporterForRestTemplate(EnhancedRestTemplateInterceptor reporter) {
            return () -> {
                for (RestTemplate restTemplate : this.restTemplates) {
                    restTemplate.getInterceptors().add(reporter);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer"})
        public PolarisLoadBalancerRequestTransformer polarisLoadBalancerRequestTransformer() {
            return new PolarisLoadBalancerRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @AutoConfigureBefore(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @Role(value=2)
    protected static class PolarisFeignClientAutoConfiguration {
        protected PolarisFeignClientAutoConfiguration() {
        }

        @Bean
        public EnhancedFeignBeanPostProcessor polarisFeignBeanPostProcessor(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedFeignBeanPostProcessor(pluginRunner);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.openfeign.loadbalancer.LoadBalancerFeignRequestTransformer"})
        public PolarisLoadBalancerFeignRequestTransformer polarisLoadBalancerFeignRequestTransformer() {
            return new PolarisLoadBalancerFeignRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    protected static class RpcEnhancementReactiveFilterConfig {
        protected RpcEnhancementReactiveFilterConfig() {
        }

        @Bean
        public EnhancedReactiveFilter enhancedReactiveFilter(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedReactiveFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    protected static class RpcEnhancementServletFilterConfig {
        protected RpcEnhancementServletFilterConfig() {
        }

        @Bean
        public FilterRegistrationBean<EnhancedServletFilter> enhancedServletFilterRegistrationBean(EnhancedServletFilter enhancedServletFilter) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)enhancedServletFilter, new ServletRegistrationBean[0]);
            filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
            filterRegistrationBean.setOrder(((Object)((Object)enhancedServletFilter)).getClass().getAnnotation(Order.class).value());
            return filterRegistrationBean;
        }

        @Bean
        public EnhancedServletFilter enhancedServletFilter(@Lazy EnhancedPluginRunner pluginRunner) {
            return new EnhancedServletFilter(pluginRunner);
        }
    }
}

