/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.feign;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;

public class EnhancedFeignClient
implements Client {
    private final Client delegate;
    private final EnhancedPluginRunner pluginRunner;

    public EnhancedFeignClient(Client target, EnhancedPluginRunner pluginRunner) {
        this.delegate = (Client)Util.checkNotNull((Object)target, (String)"target", (Object[])new Object[0]);
        this.pluginRunner = pluginRunner;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        EnhancedPluginContext enhancedPluginContext = new EnhancedPluginContext();
        HttpHeaders requestHeaders = new HttpHeaders();
        request.headers().forEach((s, strings) -> requestHeaders.addAll(s, new ArrayList(strings)));
        URI url = URI.create(request.url());
        EnhancedRequestContext enhancedRequestContext = EnhancedRequestContext.builder().httpHeaders(requestHeaders).httpMethod(HttpMethod.valueOf((String)request.httpMethod().name())).url(url).build();
        enhancedPluginContext.setRequest(enhancedRequestContext);
        enhancedPluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        enhancedPluginContext.setTargetServiceInstance((ServiceInstance)MetadataContextHolder.get().getLoadbalancerMetadata().get("LOAD_BALANCER_SERVICE_INSTANCE"), url);
        this.pluginRunner.run(EnhancedPluginType.Client.PRE, enhancedPluginContext);
        long startMillis = System.currentTimeMillis();
        try {
            Response response = this.delegate.execute(request, options);
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            HttpHeaders responseHeaders = new HttpHeaders();
            response.headers().forEach((s, strings) -> responseHeaders.addAll(s, new ArrayList(strings)));
            EnhancedResponseContext enhancedResponseContext = EnhancedResponseContext.builder().httpStatus(response.status()).httpHeaders(responseHeaders).build();
            enhancedPluginContext.setResponse(enhancedResponseContext);
            this.pluginRunner.run(EnhancedPluginType.Client.POST, enhancedPluginContext);
            Response response2 = response;
            return response2;
        }
        catch (IOException origin) {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startMillis);
            enhancedPluginContext.setThrowable(origin);
            this.pluginRunner.run(EnhancedPluginType.Client.EXCEPTION, enhancedPluginContext);
            throw origin;
        }
        finally {
            this.pluginRunner.run(EnhancedPluginType.Client.FINALLY, enhancedPluginContext);
        }
    }
}

