/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.plugin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPlugin;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.polaris.client.api.SDKContext;
import java.util.Comparator;
import java.util.List;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class DefaultEnhancedPluginRunner
implements EnhancedPluginRunner {
    private final Multimap<EnhancedPluginType, EnhancedPlugin> pluginMap = ArrayListMultimap.create();
    private final ServiceInstance localServiceInstance;

    public DefaultEnhancedPluginRunner(List<EnhancedPlugin> enhancedPlugins, Registration registration, SDKContext sdkContext) {
        if (!CollectionUtils.isEmpty(enhancedPlugins)) {
            enhancedPlugins.stream().sorted(Comparator.comparing(Ordered::getOrder)).forEach(plugin -> this.pluginMap.put((Object)plugin.getType(), plugin));
        }
        if (registration != null) {
            this.localServiceInstance = registration;
        } else {
            DefaultServiceInstance defaultServiceInstance = new DefaultServiceInstance();
            defaultServiceInstance.setServiceId(MetadataContext.LOCAL_SERVICE);
            defaultServiceInstance.setHost(sdkContext.getConfig().getGlobal().getAPI().getBindIP());
            this.localServiceInstance = defaultServiceInstance;
        }
    }

    @Override
    public void run(EnhancedPluginType pluginType, EnhancedPluginContext context) {
        for (EnhancedPlugin plugin : this.pluginMap.get((Object)pluginType)) {
            try {
                plugin.run(context);
            }
            catch (Throwable throwable) {
                plugin.handlerThrowable(context, throwable);
            }
        }
    }

    @Override
    public ServiceInstance getLocalServiceInstance() {
        return this.localServiceInstance;
    }
}

