/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.plugin;

import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class EnhancedPluginContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnhancedPluginContext.class);
    private EnhancedRequestContext request;
    private EnhancedResponseContext response;
    private Throwable throwable;
    private long delay;
    private ServiceInstance localServiceInstance;
    private ServiceInstance targetServiceInstance;

    public EnhancedRequestContext getRequest() {
        return this.request;
    }

    public void setRequest(EnhancedRequestContext request) {
        this.request = request;
    }

    public EnhancedResponseContext getResponse() {
        return this.response;
    }

    public void setResponse(EnhancedResponseContext response) {
        this.response = response;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public ServiceInstance getLocalServiceInstance() {
        return this.localServiceInstance;
    }

    public void setLocalServiceInstance(ServiceInstance localServiceInstance) {
        this.localServiceInstance = localServiceInstance;
    }

    public ServiceInstance getTargetServiceInstance() {
        return this.targetServiceInstance;
    }

    public void setTargetServiceInstance(ServiceInstance targetServiceInstance, URI url) {
        if (Objects.nonNull(targetServiceInstance)) {
            this.targetServiceInstance = targetServiceInstance;
        } else if (Objects.nonNull(url)) {
            DefaultServiceInstance defaultServiceInstance = new DefaultServiceInstance();
            defaultServiceInstance.setUri(url);
            if (defaultServiceInstance.isSecure()) {
                defaultServiceInstance.setPort(443);
            } else {
                defaultServiceInstance.setPort(80);
            }
            this.targetServiceInstance = defaultServiceInstance;
        } else {
            this.targetServiceInstance = new DefaultServiceInstance();
            LOGGER.warn("TargetServiceInstance is empty.");
        }
    }

    public String toString() {
        return "EnhancedPluginContext{request=" + this.request + ", response=" + this.response + ", throwable=" + this.throwable + ", delay=" + this.delay + ", localServiceInstance=" + this.localServiceInstance + ", targetServiceInstance=" + this.targetServiceInstance + "}";
    }
}

