/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.util.ApplicationContextAwareUtils;
import com.tencent.cloud.common.util.RequestLabelUtils;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.InstanceResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.Service;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.utils.CollectionUtils;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;

public final class PolarisEnhancedPluginUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisEnhancedPluginUtils.class);
    private static final List<HttpStatus> HTTP_STATUSES = PolarisEnhancedPluginUtils.toList(HttpStatus.NOT_IMPLEMENTED, HttpStatus.BAD_GATEWAY, HttpStatus.SERVICE_UNAVAILABLE, HttpStatus.GATEWAY_TIMEOUT, HttpStatus.HTTP_VERSION_NOT_SUPPORTED, HttpStatus.VARIANT_ALSO_NEGOTIATES, HttpStatus.INSUFFICIENT_STORAGE, HttpStatus.LOOP_DETECTED, HttpStatus.BANDWIDTH_LIMIT_EXCEEDED, HttpStatus.NOT_EXTENDED, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED);

    private PolarisEnhancedPluginUtils() {
    }

    public static ServiceCallResult createServiceCallResult(String callerHost, @Nullable String calleeServiceName, @Nullable String calleeHost, @Nullable Integer calleePort, URI uri, HttpHeaders requestHeaders, @Nullable HttpHeaders responseHeaders, @Nullable Integer statusCode, long delay, @Nullable Throwable exception) {
        ServiceCallResult resultRequest = new ServiceCallResult();
        resultRequest.setNamespace(MetadataContext.LOCAL_NAMESPACE);
        resultRequest.setService(StringUtils.isBlank((String)calleeServiceName) ? uri.getHost() : calleeServiceName);
        resultRequest.setMethod(uri.getPath());
        resultRequest.setRetCode(statusCode == null ? -1 : statusCode);
        resultRequest.setDelay(delay);
        resultRequest.setCallerService((Service)new ServiceKey(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE));
        resultRequest.setCallerIp(callerHost);
        resultRequest.setHost(StringUtils.isBlank((String)calleeHost) ? uri.getHost() : calleeHost);
        resultRequest.setPort(calleePort == null ? PolarisEnhancedPluginUtils.getPort(uri) : calleePort);
        resultRequest.setLabels(PolarisEnhancedPluginUtils.getLabels(requestHeaders));
        resultRequest.setRetStatus(PolarisEnhancedPluginUtils.getRetStatusFromRequest(responseHeaders, statusCode, exception));
        resultRequest.setRuleName(PolarisEnhancedPluginUtils.getActiveRuleNameFromRequest(responseHeaders));
        return resultRequest;
    }

    public static ResourceStat createInstanceResourceStat(@Nullable String calleeServiceName, @Nullable String calleeHost, @Nullable Integer calleePort, URI uri, @Nullable Integer statusCode, long delay, @Nullable Throwable exception) {
        ServiceKey calleeServiceKey = new ServiceKey(MetadataContext.LOCAL_NAMESPACE, StringUtils.isBlank((String)calleeServiceName) ? uri.getHost() : calleeServiceName);
        ServiceKey callerServiceKey = new ServiceKey(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE);
        InstanceResource resource = new InstanceResource(calleeServiceKey, StringUtils.isBlank((String)calleeHost) ? uri.getHost() : calleeHost, calleePort == null ? PolarisEnhancedPluginUtils.getPort(uri) : calleePort, callerServiceKey);
        return new ResourceStat((Resource)resource, statusCode == null ? -1 : statusCode, delay, PolarisEnhancedPluginUtils.getDefaultRetStatus(statusCode, exception));
    }

    @SafeVarargs
    private static <T> List<T> toList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    static boolean apply(@Nullable HttpStatus httpStatus) {
        RpcEnhancementReporterProperties reportProperties;
        if (Objects.isNull(httpStatus)) {
            return false;
        }
        try {
            reportProperties = (RpcEnhancementReporterProperties)ApplicationContextAwareUtils.getApplicationContext().getBean(RpcEnhancementReporterProperties.class);
        }
        catch (BeansException e) {
            LOG.error("get RpcEnhancementReporterProperties bean err", (Throwable)e);
            reportProperties = new RpcEnhancementReporterProperties();
        }
        List<HttpStatus> status = reportProperties.getStatuses();
        if (status.isEmpty()) {
            List<HttpStatus.Series> series = reportProperties.getSeries();
            if (reportProperties.isIgnoreInternalServerError() && Objects.equals(httpStatus, HttpStatus.INTERNAL_SERVER_ERROR)) {
                return false;
            }
            if (series.isEmpty()) {
                return HTTP_STATUSES.contains(httpStatus);
            }
            return series.contains(httpStatus.series());
        }
        return status.contains(httpStatus);
    }

    public static RetStatus getRetStatusFromRequest(HttpHeaders headers, Integer statusCode, Throwable exception) {
        return PolarisEnhancedPluginUtils.getRetStatusFromRequest(headers, PolarisEnhancedPluginUtils.getDefaultRetStatus(statusCode, exception));
    }

    static RetStatus getRetStatusFromRequest(HttpHeaders headers, RetStatus defaultVal) {
        List values;
        if (headers != null && headers.containsKey((Object)"internal-callee-retstatus") && CollectionUtils.isNotEmpty((Collection)(values = headers.get((Object)"internal-callee-retstatus")))) {
            String retStatusVal = com.tencent.polaris.api.utils.StringUtils.defaultString((String)((String)values.get(0)));
            if (Objects.equals(retStatusVal, RetStatus.RetFlowControl.getDesc())) {
                return RetStatus.RetFlowControl;
            }
            if (Objects.equals(retStatusVal, RetStatus.RetReject.getDesc())) {
                return RetStatus.RetReject;
            }
        }
        return defaultVal;
    }

    static String getActiveRuleNameFromRequest(HttpHeaders headers) {
        List values;
        if (headers != null && headers.containsKey((Object)"internal-callee-activerule") && CollectionUtils.isNotEmpty((Collection)(values = headers.get((Object)"internal-callee-activerule")))) {
            String decodedActiveRuleName = "";
            try {
                decodedActiveRuleName = URLDecoder.decode((String)new ArrayList(values).get(0), ContextConstant.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Cannot decode {} from header internal-callee-activerule.", headers.get((Object)"internal-callee-activerule").get(0), (Object)e);
            }
            return com.tencent.polaris.api.utils.StringUtils.defaultString((String)decodedActiveRuleName);
        }
        return "";
    }

    private static RetStatus getDefaultRetStatus(Integer statusCode, Throwable exception) {
        RetStatus retStatus = RetStatus.RetSuccess;
        if (exception != null) {
            retStatus = RetStatus.RetFail;
            if (exception instanceof SocketTimeoutException) {
                retStatus = RetStatus.RetTimeout;
            }
        } else if (statusCode == null || PolarisEnhancedPluginUtils.apply(HttpStatus.resolve((int)statusCode))) {
            retStatus = RetStatus.RetFail;
        }
        return retStatus;
    }

    private static int getPort(URI uri) {
        return uri.getPort() == -1 ? 80 : uri.getPort();
    }

    private static String getLabels(HttpHeaders headers) {
        List labels;
        if (headers != null && CollectionUtils.isNotEmpty((Collection)(labels = headers.get((Object)"internal-router-label"))) && labels.iterator().hasNext()) {
            String label = (String)labels.iterator().next();
            try {
                label = URLDecoder.decode(label, ContextConstant.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("unsupported charset exception " + ContextConstant.UTF_8, (Throwable)e);
            }
            return RequestLabelUtils.convertLabel((String)label);
        }
        return null;
    }

    public static Map<String, String> getLabelMap(HttpHeaders headers) {
        List labels;
        if (headers != null && CollectionUtils.isNotEmpty((Collection)(labels = headers.get((Object)"internal-router-label"))) && labels.iterator().hasNext()) {
            String label = (String)labels.iterator().next();
            try {
                label = URLDecoder.decode(label, ContextConstant.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("unsupported charset exception " + ContextConstant.UTF_8, (Throwable)e);
            }
            try {
                return (Map)new ObjectMapper().readValue(label, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
            catch (JsonProcessingException e) {
                LOG.error("parse label map exception", (Throwable)e);
            }
        }
        return null;
    }
}

