/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.webclient;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class EnhancedWebClientExchangeFilterFunction
implements ExchangeFilterFunction {
    private final EnhancedPluginRunner pluginRunner;

    public EnhancedWebClientExchangeFilterFunction(EnhancedPluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        EnhancedPluginContext enhancedPluginContext = new EnhancedPluginContext();
        EnhancedRequestContext enhancedRequestContext = EnhancedRequestContext.builder().httpHeaders(request.headers()).httpMethod(request.method()).url(request.url()).build();
        enhancedPluginContext.setRequest(enhancedRequestContext);
        enhancedPluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        enhancedPluginContext.setTargetServiceInstance((ServiceInstance)MetadataContextHolder.get().getLoadbalancerMetadata().get("LOAD_BALANCER_SERVICE_INSTANCE"), request.url());
        this.pluginRunner.run(EnhancedPluginType.Client.PRE, enhancedPluginContext);
        long startTime = System.currentTimeMillis();
        return next.exchange(request).doOnSuccess(response -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startTime);
            EnhancedResponseContext enhancedResponseContext = EnhancedResponseContext.builder().httpStatus(response.statusCode().value()).httpHeaders(response.headers().asHttpHeaders()).build();
            enhancedPluginContext.setResponse(enhancedResponseContext);
            this.pluginRunner.run(EnhancedPluginType.Client.POST, enhancedPluginContext);
        }).doOnError(t -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startTime);
            enhancedPluginContext.setThrowable((Throwable)t);
            this.pluginRunner.run(EnhancedPluginType.Client.EXCEPTION, enhancedPluginContext);
        }).doFinally(v -> this.pluginRunner.run(EnhancedPluginType.Client.FINALLY, enhancedPluginContext));
    }
}

