/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement;

import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;

public abstract class AbstractPolarisReporterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPolarisReporterAdapter.class);
    private static final List<HttpStatus> HTTP_STATUSES = AbstractPolarisReporterAdapter.toList(HttpStatus.NOT_IMPLEMENTED, HttpStatus.BAD_GATEWAY, HttpStatus.SERVICE_UNAVAILABLE, HttpStatus.GATEWAY_TIMEOUT, HttpStatus.HTTP_VERSION_NOT_SUPPORTED, HttpStatus.VARIANT_ALSO_NEGOTIATES, HttpStatus.INSUFFICIENT_STORAGE, HttpStatus.LOOP_DETECTED, HttpStatus.BANDWIDTH_LIMIT_EXCEEDED, HttpStatus.NOT_EXTENDED, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED);
    protected final RpcEnhancementReporterProperties reportProperties;

    protected AbstractPolarisReporterAdapter(RpcEnhancementReporterProperties reportProperties) {
        this.reportProperties = reportProperties;
    }

    @SafeVarargs
    private static <T> List<T> toList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    protected boolean apply(@Nullable HttpStatus httpStatus) {
        if (Objects.isNull(httpStatus)) {
            return false;
        }
        List<HttpStatus> status = this.reportProperties.getStatuses();
        if (status.isEmpty()) {
            List<HttpStatus.Series> series = this.reportProperties.getSeries();
            if (this.reportProperties.isIgnoreInternalServerError() && Objects.equals(httpStatus, HttpStatus.INTERNAL_SERVER_ERROR)) {
                return false;
            }
            if (series.isEmpty()) {
                return HTTP_STATUSES.contains(httpStatus);
            }
            try {
                return series.contains(HttpStatus.Series.valueOf((HttpStatus)httpStatus));
            }
            catch (Exception e) {
                LOG.warn("Decode http status failed.", (Throwable)e);
            }
        } else {
            return status.contains(httpStatus);
        }
        return false;
    }
}

