/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.config;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.context.config.PolarisContextAutoConfiguration;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.feign.DefaultEnhancedFeignPluginRunner;
import com.tencent.cloud.rpc.enhancement.feign.EnhancedFeignBeanPostProcessor;
import com.tencent.cloud.rpc.enhancement.feign.EnhancedFeignPluginRunner;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPlugin;
import com.tencent.cloud.rpc.enhancement.feign.plugin.reporter.ExceptionPolarisReporter;
import com.tencent.cloud.rpc.enhancement.feign.plugin.reporter.SuccessPolarisReporter;
import com.tencent.cloud.rpc.enhancement.resttemplate.BlockingLoadBalancerClientAspect;
import com.tencent.cloud.rpc.enhancement.resttemplate.EnhancedRestTemplateReporter;
import com.tencent.polaris.api.core.ConsumerAPI;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisEnabled
@ConditionalOnProperty(value={"spring.cloud.tencent.rpc-enhancement.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={RpcEnhancementReporterProperties.class})
@AutoConfigureAfter(value={PolarisContextAutoConfiguration.class})
public class RpcEnhancementAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    protected static class PolarisRestTemplateAutoConfiguration {
        @LoadBalanced
        @Autowired(required=false)
        private List<RestTemplate> restTemplates = Collections.emptyList();

        protected PolarisRestTemplateAutoConfiguration() {
        }

        @Bean
        public EnhancedRestTemplateReporter enhancedRestTemplateReporter(RpcEnhancementReporterProperties properties, ConsumerAPI consumerAPI) {
            return new EnhancedRestTemplateReporter(properties, consumerAPI);
        }

        @Bean
        public SmartInitializingSingleton setErrorHandlerForRestTemplate(EnhancedRestTemplateReporter reporter) {
            return () -> {
                for (RestTemplate restTemplate : this.restTemplates) {
                    restTemplate.setErrorHandler((ResponseErrorHandler)reporter);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient"})
        public BlockingLoadBalancerClientAspect blockingLoadBalancerClientAspect() {
            return new BlockingLoadBalancerClientAspect();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @AutoConfigureBefore(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @Role(value=2)
    protected static class PolarisFeignClientAutoConfiguration {
        protected PolarisFeignClientAutoConfiguration() {
        }

        @Bean
        public EnhancedFeignPluginRunner enhancedFeignPluginRunner(@Autowired(required=false) List<EnhancedFeignPlugin> enhancedFeignPlugins) {
            return new DefaultEnhancedFeignPluginRunner(enhancedFeignPlugins);
        }

        @Bean
        public EnhancedFeignBeanPostProcessor polarisFeignBeanPostProcessor(@Lazy EnhancedFeignPluginRunner pluginRunner) {
            return new EnhancedFeignBeanPostProcessor(pluginRunner);
        }

        @Configuration
        static class PolarisReporterConfig {
            PolarisReporterConfig() {
            }

            @Bean
            public SuccessPolarisReporter successPolarisReporter(RpcEnhancementReporterProperties properties, @Autowired(required=false) ConsumerAPI consumerAPI) {
                return new SuccessPolarisReporter(properties, consumerAPI);
            }

            @Bean
            public ExceptionPolarisReporter exceptionPolarisReporter(RpcEnhancementReporterProperties properties, @Autowired(required=false) ConsumerAPI consumerAPI) {
                return new ExceptionPolarisReporter(properties, consumerAPI);
            }
        }
    }
}

