/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.feign;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.tencent.cloud.rpc.enhancement.feign.EnhancedFeignPluginRunner;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignContext;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPlugin;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPluginType;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class DefaultEnhancedFeignPluginRunner
implements EnhancedFeignPluginRunner {
    private Multimap<String, EnhancedFeignPlugin> pluginMap = ArrayListMultimap.create();

    public DefaultEnhancedFeignPluginRunner(List<EnhancedFeignPlugin> enhancedFeignPlugins) {
        if (!CollectionUtils.isEmpty(enhancedFeignPlugins)) {
            enhancedFeignPlugins.stream().sorted(Comparator.comparing(Ordered::getOrder)).forEach(plugin -> this.pluginMap.put((Object)plugin.getType().name(), plugin));
        }
    }

    @Override
    public void run(EnhancedFeignPluginType pluginType, EnhancedFeignContext context) {
        for (EnhancedFeignPlugin plugin : this.pluginMap.get((Object)pluginType.name())) {
            try {
                plugin.run(context);
            }
            catch (Throwable throwable) {
                plugin.handlerThrowable(context, throwable);
            }
        }
    }
}

