/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.feign;

import com.tencent.cloud.rpc.enhancement.feign.EnhancedFeignPluginRunner;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignContext;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPluginType;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;

public class EnhancedFeignClient
implements Client {
    private final Client delegate;
    private EnhancedFeignPluginRunner pluginRunner;

    public EnhancedFeignClient(Client target, EnhancedFeignPluginRunner pluginRunner) {
        this.delegate = (Client)Util.checkNotNull((Object)target, (String)"target", (Object[])new Object[0]);
        this.pluginRunner = pluginRunner;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        EnhancedFeignContext enhancedFeignContext = new EnhancedFeignContext();
        enhancedFeignContext.setRequest(request);
        enhancedFeignContext.setOptions(options);
        this.pluginRunner.run(EnhancedFeignPluginType.PRE, enhancedFeignContext);
        try {
            Response response = this.delegate.execute(request, options);
            enhancedFeignContext.setResponse(response);
            this.pluginRunner.run(EnhancedFeignPluginType.POST, enhancedFeignContext);
            Response response2 = response;
            return response2;
        }
        catch (IOException origin) {
            enhancedFeignContext.setException(origin);
            this.pluginRunner.run(EnhancedFeignPluginType.EXCEPTION, enhancedFeignContext);
            throw origin;
        }
        finally {
            this.pluginRunner.run(EnhancedFeignPluginType.FINALLY, enhancedFeignContext);
        }
    }
}

