/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.feign.plugin.reporter;

import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignContext;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPlugin;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPluginType;
import com.tencent.cloud.rpc.enhancement.feign.plugin.reporter.ReporterUtils;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import feign.Request;
import feign.Response;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionPolarisReporter
implements EnhancedFeignPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionPolarisReporter.class);
    private final RpcEnhancementReporterProperties reporterProperties;
    private final ConsumerAPI consumerAPI;

    public ExceptionPolarisReporter(RpcEnhancementReporterProperties reporterProperties, ConsumerAPI consumerAPI) {
        this.reporterProperties = reporterProperties;
        this.consumerAPI = consumerAPI;
    }

    @Override
    public String getName() {
        return ExceptionPolarisReporter.class.getName();
    }

    @Override
    public EnhancedFeignPluginType getType() {
        return EnhancedFeignPluginType.EXCEPTION;
    }

    @Override
    public void run(EnhancedFeignContext context) {
        if (!this.reporterProperties.isEnabled()) {
            return;
        }
        if (this.consumerAPI != null) {
            Request request = context.getRequest();
            Response response = context.getResponse();
            Exception exception = context.getException();
            RetStatus retStatus = RetStatus.RetFail;
            if (exception instanceof SocketTimeoutException) {
                retStatus = RetStatus.RetTimeout;
            }
            LOG.debug("Will report result of {}. Request=[{}]. Response=[{}].", new Object[]{retStatus.name(), request, response});
            ServiceCallResult resultRequest = ReporterUtils.createServiceCallResult(request, retStatus);
            this.consumerAPI.updateServiceCallResult(resultRequest);
            resultRequest.setMethod("");
            this.consumerAPI.updateServiceCallResult(resultRequest);
        }
    }

    @Override
    public void handlerThrowable(EnhancedFeignContext context, Throwable throwable) {
        Request request = context.getRequest();
        Response response = context.getResponse();
        LOG.error("ExceptionPolarisReporter runs failed. Request=[{}]. Response=[{}].", new Object[]{request, response, throwable});
    }

    public int getOrder() {
        return -2147483647;
    }
}

