/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.feign.plugin.reporter;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.Service;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.utils.CollectionUtils;
import feign.Request;
import feign.RequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReporterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReporterUtils.class);

    private ReporterUtils() {
    }

    public static ServiceCallResult createServiceCallResult(Request request, RetStatus retStatus) {
        ServiceCallResult resultRequest = new ServiceCallResult();
        resultRequest.setNamespace(MetadataContext.LOCAL_NAMESPACE);
        RequestTemplate requestTemplate = request.requestTemplate();
        String serviceName = requestTemplate.feignTarget().name();
        resultRequest.setService(serviceName);
        Collection labels = (Collection)requestTemplate.headers().get("internal-router-label");
        if (CollectionUtils.isNotEmpty((Collection)labels) && labels.iterator().hasNext()) {
            String label = (String)labels.iterator().next();
            try {
                label = URLDecoder.decode(label, ContextConstant.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("unsupported charset exception " + ContextConstant.UTF_8, (Throwable)e);
            }
            resultRequest.setLabels(ReporterUtils.convertLabel(label));
        }
        URI uri = URI.create(request.url());
        resultRequest.setMethod(uri.getPath());
        resultRequest.setRetStatus(retStatus);
        String sourceNamespace = MetadataContext.LOCAL_NAMESPACE;
        String sourceService = MetadataContext.LOCAL_SERVICE;
        if (StringUtils.isNotBlank((String)sourceNamespace) && StringUtils.isNotBlank((String)sourceService)) {
            resultRequest.setCallerService((Service)new ServiceKey(sourceNamespace, sourceService));
        }
        resultRequest.setHost(uri.getHost());
        resultRequest.setPort(uri.getPort() == -1 ? 80 : uri.getPort());
        return resultRequest;
    }

    private static String convertLabel(String label) {
        label = label.replaceAll("\"|\\{|\\}", "").replaceAll(",", "|");
        return label;
    }
}

